/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hyland.content.intelligence.service.agents;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.labs.hyland.content.intelligence.AuthenticationToken;
import org.nuxeo.labs.hyland.content.intelligence.AuthenticationTokenAgents;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCall;
import org.nuxeo.labs.hyland.content.intelligence.http.ServiceCallResult;
import org.nuxeo.labs.hyland.content.intelligence.service.agents.AgentDescriptor;
import org.nuxeo.labs.hyland.content.intelligence.service.agents.HylandAgentsService;
import org.nuxeo.labs.hyland.content.intelligence.service.discovery.KDDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class HylandAgentsServiceImpl
extends DefaultComponent
implements HylandAgentsService {
    private static final Logger log = LogManager.getLogger(HylandAgentsServiceImpl.class);
    public static final String AUTH_BASE_URL_PARAM = "nuxeo.hyland.cic.auth.baseUrl";
    public static final String AUTH_ENDPOINT = "/connect/token";
    public static final String AGENTS_CLIENT_ID_PARAM = "nuxeo.hyland.cic.agents.clientId";
    public static final String AGENTS_CLIENT_SECRET_PARAM = "nuxeo.hyland.cic.agents.clientSecret";
    public static final String AGENTS_BASE_URL_PARAM = "nuxeo.hyland.cic.agents.baseUrl";
    public static final String AGENTS_ENVIRONMENT_PARAM = "nuxeo.hyland.cic.agents.environment";
    protected static Map<String, AuthenticationToken> agentsAuthTokens = null;
    protected static ServiceCall serviceCall = new ServiceCall();
    protected static final String EXT_POINT_AGENT = "agent";
    protected Map<String, AgentDescriptor> agentContribs = new HashMap<String, AgentDescriptor>();
    public static final String CONFIG_DEFAULT = "default";

    protected AgentDescriptor getDescriptor(String configName) {
        if (StringUtils.isBlank((CharSequence)configName)) {
            configName = CONFIG_DEFAULT;
        }
        return this.agentContribs.get(configName);
    }

    protected String getToken(String configName) {
        if (StringUtils.isBlank((CharSequence)configName)) {
            configName = CONFIG_DEFAULT;
        }
        AuthenticationToken token = agentsAuthTokens.get(configName);
        return token.getToken();
    }

    @Override
    public ServiceCallResult getAllAgents(String configName, Map<String, String> extraHeaders) {
        ServiceCallResult result = null;
        String bearer = this.getToken(configName);
        if (StringUtils.isBlank((CharSequence)bearer)) {
            throw new NuxeoException("No authentication info for calling the Agents Builder service.");
        }
        AgentDescriptor config = this.getDescriptor(configName);
        Object targetUrl = config.getBaseUrl();
        targetUrl = (String)targetUrl + "/v1/agents";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "*/*");
        headers.put("Authorization", "Bearer " + bearer);
        headers.put("Content-Type", "application/json");
        if (extraHeaders != null && extraHeaders.size() > 0) {
            for (String headerName : extraHeaders.keySet()) {
                headers.put(headerName, extraHeaders.get(headerName));
            }
        }
        result = serviceCall.get((String)targetUrl, headers);
        return result;
    }

    @Override
    public ServiceCallResult lookupAgent(String configName, String agentId, String versionId, Map<String, String> extraHeaders) {
        ServiceCallResult result = null;
        String bearer = this.getToken(configName);
        if (StringUtils.isBlank((CharSequence)bearer)) {
            throw new NuxeoException("No authentication info for calling the Agents Builder service.");
        }
        if (StringUtils.isBlank((CharSequence)versionId)) {
            versionId = "latest";
        }
        AgentDescriptor config = this.getDescriptor(configName);
        Object targetUrl = config.getBaseUrl();
        targetUrl = (String)targetUrl + "/v1/agents/" + agentId + "/versions/" + versionId;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "*/*");
        headers.put("Authorization", "Bearer " + bearer);
        headers.put("Content-Type", "application/json");
        if (extraHeaders != null && extraHeaders.size() > 0) {
            for (String headerName : extraHeaders.keySet()) {
                headers.put(headerName, extraHeaders.get(headerName));
            }
        }
        result = serviceCall.get((String)targetUrl, headers);
        return result;
    }

    @Override
    public ServiceCallResult invokeTask(String configName, String agentId, String versionId, String payloadJsonStr, Map<String, String> extraHeaders) {
        ServiceCallResult result = null;
        String bearer = this.getToken(configName);
        if (StringUtils.isBlank((CharSequence)bearer)) {
            throw new NuxeoException("No authentication info for calling the Agents Builder service.");
        }
        if (StringUtils.isBlank((CharSequence)versionId)) {
            versionId = "latest";
        }
        AgentDescriptor config = this.getDescriptor(configName);
        Object targetUrl = config.getBaseUrl();
        targetUrl = (String)targetUrl + "/v1/agents/" + agentId + "/versions/" + versionId + "/invoke-task";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "*/*");
        headers.put("Authorization", "Bearer " + bearer);
        headers.put("Content-Type", "application/json");
        if (extraHeaders != null && extraHeaders.size() > 0) {
            for (String headerName : extraHeaders.keySet()) {
                headers.put(headerName, extraHeaders.get(headerName));
            }
        }
        result = serviceCall.post((String)targetUrl, headers, payloadJsonStr);
        return result;
    }

    @Override
    public List<String> getAgentContribNames() {
        if (this.agentContribs == null) {
            this.agentContribs = new HashMap<String, AgentDescriptor>();
        }
        return new ArrayList<String>(this.agentContribs.keySet());
    }

    @Override
    public AgentDescriptor getAgentDescriptor(String configName) {
        if (StringUtils.isBlank((CharSequence)configName)) {
            configName = CONFIG_DEFAULT;
        }
        return this.agentContribs.get(configName);
    }

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void registerExtension(Extension extension) {
        Object[] contribs;
        super.registerExtension(extension);
        if (this.agentContribs == null) {
            this.agentContribs = new HashMap<String, AgentDescriptor>();
        }
        if (EXT_POINT_AGENT.equals(extension.getExtensionPoint()) && (contribs = extension.getContributions()) != null) {
            for (Object contrib : contribs) {
                AgentDescriptor desc = (AgentDescriptor)contrib;
                this.agentContribs.put(desc.getName(), desc);
            }
        }
    }

    public void unregisterExtension(Extension extension) {
        Object[] contribs;
        super.unregisterExtension(extension);
        if (this.agentContribs == null) {
            return;
        }
        if (EXT_POINT_AGENT.equals(extension.getExtensionPoint()) && (contribs = extension.getContributions()) != null) {
            for (Object contrib : contribs) {
                KDDescriptor desc = (KDDescriptor)contrib;
                this.agentContribs.remove(desc.getName());
            }
        }
    }

    public void start(ComponentContext context) {
        if (this.agentContribs == null) {
            log.error("No configuration found for Agents Service. Calls, if any, will fail.");
        } else {
            agentsAuthTokens = new HashMap<String, AuthenticationToken>();
            for (Map.Entry<String, AgentDescriptor> entry : this.agentContribs.entrySet()) {
                AgentDescriptor desc = entry.getValue();
                AuthenticationTokenAgents token = new AuthenticationTokenAgents(desc.getAuthenticationBaseUrl() + AUTH_ENDPOINT, desc.getAuthenticationTokenParams());
                agentsAuthTokens.put(desc.getName(), token);
                desc.checkConfigAndLogErrors();
            }
        }
    }

    public void stop(ComponentContext context) throws InterruptedException {
    }
}

