/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.generic.service.call;

import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import nuxeo.labs.generic.service.call.http.ServiceCall;
import nuxeo.labs.generic.service.call.http.ServiceCallResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.NuxeoException;

public class AuthenticationToken {
    private static final Logger log = LogManager.getLogger(AuthenticationToken.class);
    protected String id;
    protected String httpMethod;
    protected String token = null;
    protected Instant tokenExpiration = null;
    protected String authFullUrl;
    protected Map<String, String> headers;
    protected String body;
    protected JSONObject serviceResponse;
    protected ServiceCall serviceCall = new ServiceCall();

    public AuthenticationToken(String httpMethod, String authFullUrl, Map<String, String> headers, String body) {
        this.id = UUID.randomUUID().toString();
        this.httpMethod = httpMethod.toUpperCase();
        this.authFullUrl = authFullUrl;
        this.headers = headers;
        this.body = body;
    }

    public String getId() {
        return this.id;
    }

    public String getToken() {
        if (!this.isExpired()) {
            return this.token;
        }
        ServiceCallResult result = switch (this.httpMethod) {
            case "GET" -> this.serviceCall.get(this.authFullUrl, this.headers);
            case "POST" -> this.serviceCall.post(this.authFullUrl, this.headers, this.body);
            case "PUT" -> this.serviceCall.put(this.authFullUrl, this.headers, this.body);
            default -> throw new NuxeoException("Invalid HTTP method (<" + this.httpMethod + ">: We support only GET/POST/PUSH.");
        };
        if (result.callWasSuccesful()) {
            this.serviceResponse = result.getResponseAsJSONObject();
            if (this.serviceResponse.has("error")) {
                String msg = "Getting a token failed with error " + this.serviceResponse.getString("error") + ".";
                if (this.serviceResponse.has("error_description")) {
                    msg = msg + " " + this.serviceResponse.getString("error_description");
                }
                log.error(msg);
            } else {
                this.token = this.serviceResponse.getString("access_token");
                int expiresIn = this.serviceResponse.getInt("expires_in");
                this.tokenExpiration = Instant.now().plusSeconds(expiresIn - 15);
            }
        } else {
            log.error("Error getting an auth token:\n" + result.toJsonString(2));
            this.token = null;
        }
        return this.token;
    }

    public boolean isExpired() {
        return !StringUtils.isNotBlank((CharSequence)this.token) || Instant.now().isAfter(this.tokenExpiration);
    }

    public void setToken(String value) {
        this.token = value;
    }

    public void setTokenExpiration(int inNSeconds) {
        this.tokenExpiration = Instant.now().plusSeconds(inNSeconds);
    }

    public JSONObject tokenToJSONObject() {
        JSONObject obj = null;
        obj = this.serviceResponse != null ? new JSONObject(this.serviceResponse.toString()) : new JSONObject();
        obj.put("tokenUuid", (Object)this.id);
        return obj;
    }
}

