/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.generic.service.call.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nuxeo.labs.generic.service.call.http.ServiceCallResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class ServiceCall {
    private static final Logger log = LogManager.getLogger(ServiceCall.class);

    public static Map<String, String> toHeadersMap(String headersJsonStr) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)headersJsonStr)) {
            JSONObject headersJson = new JSONObject(headersJsonStr);
            Iterator keys = headersJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                headers.put(key, headersJson.getString(key));
            }
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceCallResult get(String url, Map<String, String> headers) {
        ServiceCallResult result = null;
        HttpURLConnection connection = null;
        try {
            URL theUrl = new URL(url);
            connection = (HttpURLConnection)theUrl.openConnection();
            connection.setRequestMethod("GET");
            if (headers != null) {
                headers.forEach(connection::setRequestProperty);
            }
            result = this.readResponse(connection);
        }
        catch (IOException e) {
            log.error("Error: " + e.getMessage());
            result = new ServiceCallResult("{}", -1, "IOException: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                connection = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceCallResult postOrPut(String httpMethod, String url, Map<String, String> headers, String body) {
        ServiceCallResult result = null;
        HttpURLConnection connection = null;
        try {
            URL theUrl = new URL(url);
            connection = (HttpURLConnection)theUrl.openConnection();
            connection.setRequestMethod(httpMethod);
            if (headers != null) {
                headers.forEach(connection::setRequestProperty);
            }
            connection.setDoOutput(true);
            if (body != null) {
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = body.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
            }
            result = this.readResponse(connection);
        }
        catch (IOException e) {
            log.error("Error: " + e.getMessage());
            result = new ServiceCallResult("{}", -1, "IOException: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                connection = null;
            }
        }
        return result;
    }

    public ServiceCallResult post(String url, Map<String, String> headers, String body) {
        ServiceCallResult result = this.postOrPut("POST", url, headers, body);
        return result;
    }

    public ServiceCallResult put(String url, Map<String, String> headers, String body) {
        ServiceCallResult result = this.postOrPut("PUT", url, headers, body);
        return result;
    }

    public ServiceCallResult uploadBlob(String putOrPost, Blob blob, String targetUrl, Map<String, String> headers) {
        ServiceCallResult serviceCallResult;
        block9: {
            CloseableFile f = blob.getCloseableFile();
            try {
                String mimeType = blob.getMimeType();
                if (StringUtils.isBlank((CharSequence)mimeType)) {
                    MimetypeRegistry registry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
                    mimeType = registry.getMimetypeFromBlob(blob);
                }
                serviceCallResult = this.uploadFile(putOrPost, f.getFile(), targetUrl, mimeType, headers);
                if (f == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (f != null) {
                        try {
                            f.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NuxeoException("IOException while uploading the blob.", (Throwable)e);
                }
            }
            f.close();
        }
        return serviceCallResult;
    }

    public ServiceCallResult uploadFile(String putOrPost, File file, String targetUrl, String contentType, Map<String, String> headers) {
        switch (putOrPost = putOrPost.toUpperCase()) {
            case "POST": 
            case "PUT": {
                break;
            }
            default: {
                throw new NuxeoException("Oonly PUT or POST handled.");
            }
        }
        ServiceCallResult result = null;
        if (StringUtils.isBlank((CharSequence)contentType)) {
            try {
                contentType = Files.probeContentType(file.toPath());
            }
            catch (IOException e) {
                contentType = "application/octet-stream";
            }
        }
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(targetUrl)).header("Content-Type", contentType);
            if (headers != null && !headers.isEmpty()) {
                headers.forEach(builder::header);
            }
            HttpRequest.BodyPublisher body = HttpRequest.BodyPublishers.ofFile(file.toPath());
            switch (putOrPost) {
                case "POST": {
                    builder.POST(body);
                    break;
                }
                case "PUT": {
                    builder.PUT(body);
                }
            }
            HttpRequest request = builder.build();
            try {
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                result = new ServiceCallResult("{}", response.statusCode(), response.body());
            }
            catch (IOException | InterruptedException e) {
                result = new ServiceCallResult("{}", -1, "Error uploading the file: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new NuxeoException("Exception while uploading the blob.", (Throwable)e);
        }
        return result;
    }

    public ServiceCallResult downloadFile(String targetUrl, Map<String, String> headers) {
        ServiceCallResult result;
        block29: {
            result = null;
            Blob blob = null;
            HttpURLConnection connection = null;
            try {
                int status;
                URL url = new URL(targetUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setDoInput(true);
                if (headers != null) {
                    headers.forEach(connection::setRequestProperty);
                }
                if ((status = connection.getResponseCode()) < 200 || status >= 300) {
                    String error = "";
                    try (InputStream errorStream2 = connection.getErrorStream();){
                        if (errorStream2 != null) {
                            error = new String(errorStream2.readAllBytes());
                        }
                    }
                    catch (IOException errorStream2) {
                        // empty catch block
                    }
                    Blob nullBlob = null;
                    result = new ServiceCallResult(nullBlob, status, error);
                    break block29;
                }
                String filename = ServiceCall.extractFileName(connection, url);
                String mimeType = connection.getContentType();
                blob = Blobs.createBlobWithExtension((String)".tmp");
                blob.setFilename(filename);
                blob.setMimeType(mimeType);
                File destinationFile = blob.getFile();
                try (InputStream in = connection.getInputStream();
                     FileOutputStream out = new FileOutputStream(destinationFile);){
                    in.transferTo(out);
                }
                result = new ServiceCallResult(blob, status, connection.getResponseMessage());
            }
            catch (IOException e) {
                throw new NuxeoException("Error downloading a file", (Throwable)e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                    connection = null;
                }
            }
        }
        return result;
    }

    public static String extractFileName(HttpURLConnection connection, URL url) {
        String[] parts;
        String contentDisposition = connection.getHeaderField("Content-Disposition");
        if (contentDisposition != null && contentDisposition.contains("filename=") && (parts = contentDisposition.split("filename=")).length > 1) {
            return parts[1].replaceAll("\"", "").trim();
        }
        String path = url.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public ServiceCallResult readResponse(HttpURLConnection connection) throws IOException {
        ServiceCallResult result = null;
        int responseCode = connection.getResponseCode();
        if (ServiceCallResult.isHttpSuccess(responseCode)) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder responseStr = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    responseStr.append(line.trim());
                }
                result = new ServiceCallResult(responseStr.toString(), responseCode, connection.getResponseMessage());
            }
        } else {
            result = new ServiceCallResult("{}", responseCode, connection.getResponseMessage());
        }
        return result;
    }
}

