/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.generic.service.call.operations;

import java.util.Map;
import nuxeo.labs.generic.service.call.AuthenticationToken;
import nuxeo.labs.generic.service.call.AuthenticationTokens;
import nuxeo.labs.generic.service.call.http.ServiceCall;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;

@Operation(id="Services.CallRESTServiceForToken", category="Services", label="Call a REST Service", description="Call a service, returns the raw JSON result. The method is required and you pass in headersJsonStr all the required headers, and in bodyStr the raw body (for POST/PUT calls). The operation calls the service and, so, gets a token. The operation returns a JSON blob (call its getString() method) containing the tokenUuid property in addition to the usual JSON return  containing the token (with access_token, expires_in, etc.). Other calls expect only the tokenUuid.")
public class CallServiceForTokenOp {
    public static final String ID = "Services.CallRESTServiceForToken";
    @Context
    protected CoreSession session;
    @Param(name="httpMethod", required=true)
    protected String httpMethod;
    @Param(name="url", required=true)
    protected String url;
    @Param(name="headersJsonStr", required=false)
    protected String headersJsonStr;
    @Param(name="bodyStr", required=false)
    protected String bodyStr;

    @OperationMethod
    public Blob run() {
        Map<String, String> headers = ServiceCall.toHeadersMap(this.headersJsonStr);
        AuthenticationToken token = AuthenticationTokens.getInstance().newToken(this.httpMethod, this.url, headers, this.bodyStr);
        String tokenValue = token.getToken();
        return Blobs.createJSONBlob((String)token.tokenToJSONObject().toString());
    }
}

