/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.okta.core.authentication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.auth.saml.SAMLCredential;
import org.nuxeo.ecm.platform.auth.saml.user.AbstractUserResolver;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.xml.XMLObject;

public class OktaUserResolver
extends AbstractUserResolver {
    private static final Log log = LogFactory.getLog(OktaUserResolver.class);

    public void init(Map<String, String> map) {
    }

    public String getLoginName(SAMLCredential samlCredential) {
        return null;
    }

    public String findOrCreateNuxeoUser(SAMLCredential userInfo) {
        String username = this.findNuxeoUser(userInfo);
        if (username == null) {
            DocumentModel userDoc = this.createNuxeoUser(userInfo);
            return userDoc.getId();
        }
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        this.updateUserInfo(userManager.getUserModel(username), userInfo);
        return username;
    }

    public String findNuxeoUser(SAMLCredential credential) {
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            HashMap<String, String> query = new HashMap<String, String>();
            query.put(userManager.getUserEmailField(), credential.getNameID().getValue());
            DocumentModelList users = userManager.searchUsers(query, null);
            if (users.isEmpty()) {
                return null;
            }
            return (String)((Object)((DocumentModel)users.get(0)).getPropertyValue(userManager.getUserIdField()));
        }
        catch (NuxeoException e) {
            log.error((Object)("Error while search user in UserManager using email " + credential.getNameID().getValue()), (Throwable)e);
            return null;
        }
    }

    public DocumentModel createNuxeoUser(SAMLCredential credential) {
        DocumentModel userDoc;
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            userDoc = userManager.getBareUserModel();
            userDoc.setPropertyValue(userManager.getUserIdField(), (Serializable)((Object)credential.getNameID().getValue()));
            userDoc = userManager.createUser(userDoc);
            userDoc = this.updateUserInfo(userDoc, credential);
        }
        catch (NuxeoException e) {
            log.error((Object)("Error while creating user " + credential.getNameID().getValue() + "in UserManager"), (Throwable)e);
            return null;
        }
        return userDoc;
    }

    public DocumentModel updateUserInfo(DocumentModel user, SAMLCredential credential) {
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            NuxeoPrincipal principal = userManager.getPrincipal((String)((Object)user.getPropertyValue(userManager.getUserIdField())));
            principal.setEmail(credential.getNameID().getValue());
            for (Attribute attribute : credential.getAttributes()) {
                switch (attribute.getName()) {
                    case "firstName": {
                        principal.setFirstName(((XMLObject)attribute.getAttributeValues().get(0)).getDOM().getTextContent());
                        break;
                    }
                    case "lastName": {
                        principal.setLastName(((XMLObject)attribute.getAttributeValues().get(0)).getDOM().getTextContent());
                        break;
                    }
                    case "groups": {
                        this.addToGroups(attribute, principal);
                        break;
                    }
                }
            }
            userManager.updateUser(principal.getModel());
            return userManager.getUserModel(principal.getName());
        }
        catch (NuxeoException e) {
            log.error((Object)("Error while search user in UserManager using email " + credential.getNameID().getValue()), (Throwable)e);
            return null;
        }
    }

    protected void addToGroups(Attribute attribute, NuxeoPrincipal principal) {
        ArrayList<String> groups = new ArrayList<String>();
        for (XMLObject value : attribute.getAttributeValues()) {
            String group = value.getDOM().getTextContent();
            if ("Everyone".equals(group)) continue;
            groups.add(group);
        }
        principal.setGroups(groups);
    }
}

