/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.operations.document;

import java.util.Collections;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;

@Operation(id="Document.PublishRenditionOp", category="Document", label="Document Publish Rendition", description="Publishes the rendition to the target Section, returns the published document. Current user must have enoiugh right to publish in this section.")
public class PublishRenditionOp {
    public static final String ID = "Document.PublishRenditionOp";
    @Context
    protected CoreSession coreSession;
    @Context
    protected PublisherService publisherService;
    @Param(name="targetSectionRef", required=true)
    protected String targetSectionRef;
    @Param(name="renditionName", required=true)
    protected String renditionName;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel inDoc) {
        String targetPath;
        String defaultTreeName = (String)this.publisherService.getAvailablePublicationTree().get(0);
        PublicationTree tree = this.publisherService.getPublicationTree(defaultTreeName, this.coreSession, null);
        if (this.targetSectionRef.startsWith("/")) {
            targetPath = this.targetSectionRef;
        } else {
            DocumentModel sectionDoc = this.coreSession.getDocument((DocumentRef)new IdRef(this.targetSectionRef));
            targetPath = sectionDoc.getPathAsString();
        }
        PublicationNode targetNode = tree.getNodeByPath(targetPath);
        SimpleCorePublishedDocument publishedDocument = (SimpleCorePublishedDocument)tree.publish(inDoc, targetNode, Collections.singletonMap("renditionName", this.renditionName));
        DocumentModel proxy = publishedDocument.getProxy();
        return proxy;
    }
}

