/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.operations.images;

import java.io.IOException;
import java.util.Map;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.labs.operations.images.ImagesSheetBuilder;

@Operation(id="ImagesSheet.CustomBuild", category="Conversion", label="Custom Images Sheet Builder", description="Build an image sheet from the input documents, using a custom contributed command line and its parameters. Use the thumbnail of documents that do not have the Picture facet. Outputs the resulting image (always a jpeg). See ImageMagick montage command line for details about the parameters")
public class ImagesSheetBuilderCustomOp {
    public static final String ID = "ImagesSheet.CustomBuild";
    @Param(name="commandLine", required=true)
    protected String commandLine;
    @Param(name="parameters", required=false)
    protected Properties parameters;
    @Param(name="imageViewToUse", required=false, values={"Medium"})
    protected String imageViewToUse;
    @Param(name="useDocTitle", required=false, values={"false"})
    protected boolean useDocTitle = false;

    @OperationMethod
    public Blob run(DocumentModelList input) throws NuxeoException, IOException, CommandNotAvailable {
        return this.run(input, null);
    }

    @OperationMethod
    public Blob run(BlobList input) throws NuxeoException, IOException, CommandNotAvailable {
        return this.run(null, input);
    }

    protected Blob run(DocumentModelList docs, BlobList blobs) throws NuxeoException, IOException, CommandNotAvailable {
        ImagesSheetBuilder isb = null;
        if (docs != null) {
            isb = new ImagesSheetBuilder(docs);
        } else if (blobs != null) {
            isb = new ImagesSheetBuilder(blobs);
        } else {
            return null;
        }
        isb.setCommand(this.commandLine).setView(this.imageViewToUse).setUseDocTitle(this.useDocTitle);
        CmdParameters moreParams = null;
        if (this.parameters != null && this.parameters.size() > 0) {
            moreParams = new CmdParameters();
            for (Map.Entry oneParam : this.parameters.entrySet()) {
                moreParams.addNamedParameter((String)oneParam.getKey(), (String)oneParam.getValue());
            }
        }
        Blob result = isb.build(moreParams);
        return result;
    }
}

