/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.operations.usermanagement;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="CreateOrUpdateGroup", category="Users & Groups", label="Create or Update Group", description="Create or Update Group")
public class CreateOrUpdateGroupOp {
    public static final String ID = "CreateOrUpdateGroup";
    @Context
    protected CoreSession session;
    @Context
    protected UserManager userManager;
    @Param(name="groupname")
    protected String groupname;
    @Param(name="grouplabel")
    protected String grouplabel;
    @Param(name="tenantId", required=false)
    protected String tenantId;

    @OperationMethod
    public DocumentModel run() {
        boolean isUpdate = true;
        DocumentModel groupDoc = this.userManager.getGroupModel(this.getActualGroupName());
        if (groupDoc == null) {
            groupDoc = this.userManager.getBareGroupModel();
            groupDoc.setPropertyValue("group:groupname", (Serializable)((Object)this.groupname));
            isUpdate = false;
        }
        groupDoc.setPropertyValue("group:grouplabel", (Serializable)((Object)this.grouplabel));
        if (StringUtils.isNotBlank((String)this.tenantId)) {
            groupDoc.setPropertyValue("group:tenantId", (Serializable)((Object)this.tenantId));
        }
        if (!isUpdate) {
            return this.userManager.createGroup(groupDoc);
        }
        this.userManager.updateGroup(groupDoc);
        return this.userManager.getGroupModel(this.getActualGroupName());
    }

    protected String getActualGroupName() {
        if (StringUtils.isNotBlank((String)this.tenantId)) {
            return "tenant_" + this.tenantId + "_" + this.groupname;
        }
        return this.groupname;
    }
}

