/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.operations.document;

import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.types.ListType;

@Operation(id="AddComplexProperty", category="Document", label="Add Complex Property From Json String", description="This operation can add new fields to a multivalued complex metadata. The value parameter is a String containing the JSON list of new value for the metadata given in xpath")
public class AddEntryToComplexProperties {
    public static final String ID = "AddComplexProperty";
    @Context
    protected CoreSession session;
    @Context
    protected AutomationService service;
    @Context
    protected OperationContext ctx;
    @Param(name="xpath")
    protected String xpath;
    @Param(name="ComplexJsonProperties")
    protected String ComplexJsonProperties;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws OperationException, IOException {
        Property complexMeta = doc.getProperty(this.xpath);
        ListType ltype = (ListType)complexMeta.getField().getType();
        if (!ltype.getFieldType().isComplexType()) {
            throw new OperationException("Property type is not supported by this operation");
        }
        List newVals = ComplexTypeJSONDecoder.decodeList((ListType)ltype, (String)this.ComplexJsonProperties);
        for (Object newVal : newVals) {
            complexMeta.addValue(newVal);
        }
        if (this.save) {
            doc = this.session.saveDocument(doc);
            this.session.save();
        }
        return doc;
    }
}

