/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.operations.document;

import java.util.Set;
import java.util.TreeSet;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.tag.TagService;

@Operation(id="Document.GetTags", category="Document", label="Get tags", description="Returns the tags of the document (sorted")
public class DocumentGetTagsOp {
    public static final String ID = "Document.GetTags";
    @Context
    protected CoreSession session;
    @Context
    protected TagService tagService;
    @Param(name="currentUserOnly", required=false)
    protected boolean currentUserOnly = false;

    @OperationMethod
    public Set<String> run(DocumentModel input) {
        Set result = this.tagService.getTags(this.session, input.getId());
        return result;
    }

    @OperationMethod
    public Set<String> run(DocumentModelList input) {
        TreeSet<String> tags = new TreeSet<String>();
        for (DocumentModel doc : input) {
            Set tempTags = this.tagService.getTags(this.session, doc.getId());
            tags.addAll(tempTags);
        }
        return tags;
    }
}

