/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.operations.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.labs.operations.services.HTTPUtils;

@Operation(id="HTTPlabs.DownloadFile", category="Files", label="HTTP Download File", description="Download the file referenced by the url (using HTTP GET) and returns a blob")
public class HTTPDownloadFile {
    public static final String ID = "HTTPlabs.DownloadFile";
    public static final Log log = LogFactory.getLog(HTTPDownloadFile.class);
    protected static final int BUFFER_SIZE = 4096;
    protected static String tempFolderPath = null;
    protected static final String MUTEX = "HTTPDownloadFileLock";
    @Context
    protected OperationContext ctx;
    @Param(name="url", required=true)
    protected String url;
    @Param(name="headers", required=false)
    protected Properties headers;
    @Param(name="headersAsJSON", required=false)
    protected String headersAsJSON;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Blob run() throws IOException {
        FileBlob result = null;
        HttpURLConnection http = null;
        String error = "";
        String resultStatus = "";
        boolean isUnknownHost = false;
        try {
            URL theURL = new URL(this.url);
            http = (HttpURLConnection)theURL.openConnection();
            HTTPUtils.addHeaders(http, this.headers, this.headersAsJSON);
            if (http.getResponseCode() == 200) {
                String fileName = "";
                String disposition = http.getHeaderField("Content-Disposition");
                String contentType = http.getContentType();
                String encoding = http.getContentEncoding();
                if (disposition != null) {
                    int index = disposition.indexOf("filename=");
                    if (index > -1) {
                        fileName = disposition.substring(index + 9);
                    }
                } else {
                    fileName = this.url.substring(this.url.lastIndexOf("/") + 1, this.url.length());
                }
                if (StringUtils.isEmpty((String)fileName)) {
                    fileName = "DownloadedFile-" + UUID.randomUUID().toString();
                }
                File tempFile = new File(this.getTempFolderPath() + File.separator + UUID.randomUUID().toString());
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                InputStream inputStream = http.getInputStream();
                int bytesRead = -1;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                inputStream.close();
                result = new FileBlob(tempFile, contentType, encoding);
                result.setFilename(fileName);
            }
        }
        catch (Exception e) {
            error = e.getMessage();
            if (e instanceof UnknownHostException) {
                isUnknownHost = true;
            }
        }
        finally {
            int status = 0;
            String statusMessage = "";
            if (isUnknownHost) {
                status = 0;
                statusMessage = "UnknownHostException";
            } else {
                try {
                    status = http.getResponseCode();
                    statusMessage = http.getResponseMessage();
                }
                catch (Exception e) {
                    statusMessage = "Error getting the status message itself";
                }
            }
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode resultObj = mapper.createObjectNode();
            resultObj.put("status", status);
            resultObj.put("statusMessage", statusMessage);
            resultObj.put("error", error);
            ObjectWriter ow = mapper.writer();
            resultStatus = ow.writeValueAsString((Object)resultObj);
        }
        this.ctx.put("httpDownloadFileStatus", (Object)resultStatus);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getTempFolderPath() throws IOException {
        if (tempFolderPath != null) return tempFolderPath;
        String string = MUTEX;
        synchronized (MUTEX) {
            if (tempFolderPath != null) return tempFolderPath;
            tempFolderPath = Files.createTempDirectory("HTTPDownloadFile", new FileAttribute[0]).toString();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tempFolderPath;
        }
    }
}

