/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.operations.services;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Operation(id="Vocabulary.AddEntry", category="Services", label="Vocabulary: Add Entry", description="Add a new entry in the <i>name</i> directory only if <i>id</i> is not found (an existing entry is not updated). If <i>label</i> is empty, it is set to the id. WARNING: Current user must have enough rights to write in a directory.")
public class VocabularyAddEntryOp {
    public static final String ID = "Vocabulary.AddEntry";
    protected static HashMap<String, Boolean> vocabularyAndHasParent = new HashMap();
    @Context
    protected DirectoryService directoryService;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="name", required=true)
    String name;
    @Param(name="id", required=true)
    String id;
    @Param(name="label", required=false)
    String label;
    @Param(name="parent", required=false)
    String parent = "";
    @Param(name="obsolete", required=false)
    long obsolete = 0L;
    @Param(name="ordering", required=false)
    long ordering = 0L;

    @OperationMethod
    public void run() {
        if (StringUtils.isNotBlank((String)this.id)) {
            boolean hasParent;
            if (vocabularyAndHasParent.get(this.name) == null) {
                String dirSchema = this.directoryService.getDirectorySchema(this.name);
                Schema schema = this.schemaManager.getSchema(dirSchema);
                hasParent = schema.hasField("parent");
                vocabularyAndHasParent.put(this.name, hasParent);
            } else {
                hasParent = vocabularyAndHasParent.get(this.name);
            }
            Session directorySession = this.directoryService.open(this.name);
            if (!directorySession.hasEntry(this.id)) {
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("id", this.id);
                if (this.label == null || this.label.isEmpty()) {
                    this.label = this.id;
                }
                entry.put("label", this.label);
                if (hasParent) {
                    entry.put("parent", this.parent);
                }
                entry.put("obsolete", this.obsolete);
                entry.put("ordering", this.ordering);
                directorySession.createEntry(entry);
            }
            directorySession.close();
        }
    }
}

