/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.operations.ui;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;

@Operation(id="NavigateToUrl", category="User Interface", label="Navigate To Url", description="Redirect to the a nuxeo URL passed as a parameter, for instance the parameter can be: /nuxeo/site/automation/doc")
public class NavigateToUrl {
    public static final String ID = "NavigateToUrl";
    @Param(name="URL")
    protected String URL;
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public void run() throws OperationException {
        HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String targetURL = this.URL;
        try {
            request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)new Boolean(true));
            response.sendRedirect(targetURL);
            response.flushBuffer();
            FacesContext.getCurrentInstance().responseComplete();
            this.ctx.getVars().put("Outcome", null);
        }
        catch (IOException e) {
            throw new OperationException("cannot redirect");
        }
    }
}

