/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.operations.usermanagement;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="CreateOrUpdateUser", category="Users & Groups", label="Create or Update User", description="Create or Update User.")
public class CreateOrUpdateUserOp {
    public static final String ID = "CreateOrUpdateUser";
    @Context
    protected CoreSession session;
    @Context
    protected UserManager userManager;
    @Param(name="username")
    protected String username;
    @Param(name="password", required=false)
    protected String password;
    @Param(name="properties", required=false)
    protected Properties properties = new Properties();
    @Param(name="groups", required=false)
    protected StringList groups = new StringList();

    @OperationMethod
    public DocumentModel run() {
        boolean isUpdate = true;
        DocumentModel userDoc = this.userManager.getUserModel(this.username);
        if (userDoc == null) {
            userDoc = this.userManager.getBareUserModel();
            userDoc.setPropertyValue("user:username", (Serializable)((Object)this.username));
            isUpdate = false;
        }
        if (StringUtils.isNotBlank((String)this.password)) {
            userDoc.setPropertyValue("user:password", (Serializable)((Object)this.password));
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("user:")) {
                key = "user:" + key;
            }
            userDoc.setPropertyValue(key, (Serializable)entry.getValue());
        }
        if (this.groups.size() > 0) {
            userDoc.setPropertyValue("user:groups", (Serializable)this.groups);
        }
        if (isUpdate) {
            this.userManager.updateUser(userDoc);
            return this.userManager.getUserModel(this.username);
        }
        return this.userManager.createUser(userDoc);
    }
}

