/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.automation.helpers;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.context.ContextHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;

public class FileUtils
implements ContextHelper {
    public Blob readFileToBlob(String inPath) throws IOException {
        if (StringUtils.isBlank((String)inPath)) {
            throw new IllegalArgumentException("The file path parameter cannot be empty or null");
        }
        File theFile = new File(inPath);
        return Blobs.createBlob((File)theFile);
    }

    public String readFileToText(String inPath) throws IOException {
        if (StringUtils.isBlank((String)inPath)) {
            throw new IllegalArgumentException("The file path parameter cannot be empty or null");
        }
        Blob b = this.readFileToBlob(inPath);
        return b.getString();
    }

    public File createFile(String inPath, boolean inOverwrite) throws IOException {
        File f = new File(inPath);
        if (inOverwrite && f.exists()) {
            f.delete();
        }
        if (f.createNewFile()) {
            return f;
        }
        return null;
    }

    public File createFile(String inPath) throws IOException {
        return this.createFile(inPath, false);
    }

    public File appendToFile(File inFile, String inWhat) throws IOException {
        org.apache.commons.io.FileUtils.writeStringToFile((File)inFile, (String)inWhat, (Charset)Charset.defaultCharset(), (boolean)true);
        return inFile;
    }

    public void deleteFile(String inPath) {
        if (StringUtils.isNotBlank((String)inPath)) {
            this.deleteFile(new File(inPath));
        }
    }

    public void deleteFile(File inFile) {
        if (inFile != null && inFile.exists()) {
            inFile.delete();
        }
    }

    public void saveBlob(Blob inBlob, String inPath) throws IOException {
        File dest = new File(inPath);
        inBlob.transferTo(dest);
    }

    public ArrayList<String> getFiles(String inFolderPath) {
        File folder = new File(inFolderPath);
        ArrayList<String> files = new ArrayList<String>();
        if (folder.exists() && folder.isDirectory()) {
            for (File f : folder.listFiles()) {
                if (!f.isFile() || f.isHidden()) continue;
                files.add(f.getAbsolutePath());
            }
        }
        return files;
    }

    public ArrayList<String> getFolders(String inFolderPath) {
        File folder = new File(inFolderPath);
        ArrayList<String> files = new ArrayList<String>();
        if (folder.exists() && folder.isDirectory()) {
            for (File f : folder.listFiles()) {
                if (!f.isDirectory() || f.isHidden()) continue;
                files.add(f.getAbsolutePath());
            }
        }
        return files;
    }

    public boolean createFolder(String inContainerPath, String inFolderName) {
        boolean result = false;
        File folder = new File(inContainerPath);
        if (folder.exists() && folder.isDirectory()) {
            File newFolder = new File(inContainerPath, inFolderName);
            result = newFolder.mkdir();
        }
        return result;
    }
}

