/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.pdf.toolkit.operations;

import java.io.IOException;
import java.util.Base64;
import nuxeo.labs.pdf.toolkit.PDFToImages;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;

@Operation(id="PDFLabs.JpegImagePreview", category="Conversion", label="PDF Jpeg Image Preview", description="Input is either a Blob or a document. If a document, xpath is the field to use, file:content by default. pageNumber is an integer, starting at 1. Result jpeg is max 1024x1024, dpi 300")
public class PDFJpegimagePreviewOp {
    public static final String ID = "PDFLabs.JpegImagePreview";
    @Context
    protected CoreSession session;
    @Param(name="xpath", required=false)
    protected String xpath = "file:content";
    @Param(name="pageNumber", required=true)
    protected Integer pageNumber;
    @Param(name="asBase64", required=false)
    protected Boolean asBase64 = false;

    @OperationMethod
    public Blob run(DocumentModel doc) {
        Blob b = (Blob)doc.getPropertyValue(this.xpath);
        return this.run(b);
    }

    @OperationMethod
    public Blob run(Blob blob) {
        PDFToImages pageExtractor = new PDFToImages(blob);
        Blob jpeg = pageExtractor.getJpegPreviewImage(this.pageNumber);
        if (this.asBase64.booleanValue()) {
            byte[] bytes;
            try {
                bytes = jpeg.getByteArray();
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
            String base64 = Base64.getEncoder().encodeToString(bytes);
            jpeg = Blobs.createBlob((String)base64);
        }
        return jpeg;
    }
}

