/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.pdf.toolkit.operations;

import nuxeo.labs.pdf.toolkit.PDFToImages;
import org.json.JSONArray;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="PDFLabs.GetThumbnails", category="Conversion", label="PDF Get Thumbnails", description="Input is either a Blob or a document. If a document, xpath is the field to use, file:content by default. Calculate thumbnails of each page of the input PDF. Returns a JSON Array (as string) of the ordered thumbnails, jpeg, as base64. The operation accepts maxWidth (default 512), maxHeight (defailt 512) and dpi (default 150) as optional parameters. Warning: as all is in memory as base64, don't use big images and high dpi.")
public class PDFThumbnailsOp {
    public static final String ID = "PDFLabs.GetThumbnails";
    @Context
    protected CoreSession session;
    @Param(name="xpath", required=false)
    protected String xpath = "file:content";
    @Param(name="width", required=false)
    protected Integer width = PDFToImages.DEFAULT_THUMBNAIL_SIZE;
    @Param(name="height", required=false)
    protected Integer height = PDFToImages.DEFAULT_THUMBNAIL_SIZE;
    @Param(name="dpi", required=false)
    protected Integer dpi = PDFToImages.DEFAULT_DPI;

    @OperationMethod
    public Blob run(DocumentModel doc) {
        Blob b = (Blob)doc.getPropertyValue(this.xpath);
        return this.run(b);
    }

    @OperationMethod
    public Blob run(Blob blob) {
        PDFToImages pdfThumbnails = new PDFToImages(blob);
        pdfThumbnails.setDpi(this.dpi);
        BlobList thumbnails = pdfThumbnails.createThumbnails(this.width, this.height);
        JSONArray array = PDFToImages.toBase64JSONArray(thumbnails);
        String json = array.toString();
        return Blobs.createJSONBlob((String)json);
    }
}

