/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.pdf.toolkit.operations;

import nuxeo.labs.pdf.toolkit.PDFDestinationHandler;
import nuxeo.labs.pdf.toolkit.PDFPageRemover;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="PDFLabs.RemovePages", category="Conversion", label="PDF Remove Pages", description="Input is either a Blob or a document. If a document, xpath is the field to use, file:content by default. pageRange is a string, required, formated as when you display a print dialog, with pages starting at 1. For example, '2-5' removes page 2 to 5 (inclusive). '2-5,8, 10-14' removes pages 2 to 5, 8 and 10 to 14. destinationJsonStr is a JSON object telling the operation what to do with the pdf. Not passed => download. See documentation for details.")
public class PDFPageRemoverOp {
    public static final String ID = "PDFLabs.RemovePages";
    @Context
    protected CoreSession session;
    @Param(name="xpath", required=false)
    protected String xpath = "file:content";
    @Param(name="pageRange", required=true)
    protected String pageRange;
    @Param(name="destinationJsonStr", required=false)
    protected String destinationJsonStr;
    protected DocumentModel doc = null;

    @OperationMethod
    public Blob run(DocumentModel doc) {
        Blob b = (Blob)doc.getPropertyValue(this.xpath);
        this.doc = doc;
        return this.run(b);
    }

    @OperationMethod
    public Blob run(Blob blob) {
        PDFPageRemover pageRemover = new PDFPageRemover(blob);
        Blob resultPdf = pageRemover.removePages(this.pageRange);
        PDFDestinationHandler destHandler = new PDFDestinationHandler(this.doc, resultPdf, this.destinationJsonStr);
        Blob result = destHandler.run();
        return result;
    }
}

