/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.pdf.toolkit;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;
import nuxeo.labs.pdf.toolkit.PDFTools;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.json.JSONArray;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.runtime.api.Framework;

public class PDFToImages {
    public static int DEFAULT_THUMBNAIL_SIZE = 512;
    public static int DEFAULT_DPI = 512;
    public static int PREVIEW_PAGE_MAX_SIZE = 1024;
    protected int width = DEFAULT_THUMBNAIL_SIZE;
    protected int height = DEFAULT_THUMBNAIL_SIZE;
    protected int dpi = DEFAULT_DPI;
    protected Blob pdfBlob;

    public PDFToImages(DocumentModel doc) {
        this(doc, null);
    }

    public PDFToImages(DocumentModel doc, String xpath) {
        if (StringUtils.isBlank((CharSequence)xpath)) {
            xpath = "file:content";
        }
        this.pdfBlob = (Blob)doc.getPropertyValue(xpath);
    }

    public PDFToImages(Blob b) {
        this.pdfBlob = b;
    }

    public void setWidth(int value) {
        this.width = value > 0 ? value : DEFAULT_THUMBNAIL_SIZE;
    }

    public void setheight(int value) {
        this.height = value > 0 ? value : DEFAULT_THUMBNAIL_SIZE;
    }

    public void setSize(int size) {
        this.setWidth(size);
        this.setheight(size);
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setheight(height);
    }

    public void setSize(String size) {
        if (StringUtils.isBlank((CharSequence)size)) {
            this.setSize(DEFAULT_THUMBNAIL_SIZE);
            return;
        }
        int idx = size.indexOf(120);
        if (idx <= 0 || idx == size.length() - 1) {
            throw new IllegalArgumentException("Malformed dimension string: " + size);
        }
        String wStr = size.substring(0, idx).trim();
        String hStr = size.substring(idx + 1).trim();
        try {
            this.width = Integer.parseInt(wStr);
            this.height = Integer.parseInt(hStr);
            this.setSize(this.width, this.height);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Malformed dimension string: " + size, e);
        }
    }

    public void setDpi(int value) {
        this.dpi = value > 0 ? value : DEFAULT_DPI;
    }

    public BlobList createThumbnails(int size) {
        this.setSize(size);
        return this.createThumbnails();
    }

    public BlobList createThumbnails(int width, int height) {
        this.setSize(width, height);
        return this.createThumbnails();
    }

    public BlobList createThumbnails(String size) {
        this.setSize(size);
        if (StringUtils.isBlank((CharSequence)size)) {
            return this.createThumbnails(0);
        }
        int idx = size.indexOf(120);
        if (idx <= 0 || idx == size.length() - 1) {
            throw new IllegalArgumentException("Malformed dimension string: " + size);
        }
        String wStr = size.substring(0, idx).trim();
        String hStr = size.substring(idx + 1).trim();
        try {
            this.width = Integer.parseInt(wStr);
            this.height = Integer.parseInt(hStr);
            if (this.width <= 0) {
                this.width = DEFAULT_THUMBNAIL_SIZE;
            }
            if (this.height == 0) {
                this.height = DEFAULT_THUMBNAIL_SIZE;
            }
            return this.createThumbnails();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Malformed dimension string: " + size, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public BlobList createThumbnails() {
        ImageIO.scanForPlugins();
        BlobList results = new BlobList();
        try (CloseableFile source = this.pdfBlob.getCloseableFile();){
            BlobList blobList;
            block15: {
                PDDocument document = Loader.loadPDF((File)source.getFile());
                try {
                    PDFRenderer renderer = new PDFRenderer(document);
                    int pageCount = document.getNumberOfPages();
                    for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                        BufferedImage pageImage = renderer.renderImageWithDPI(pageIndex, (float)this.dpi, ImageType.RGB);
                        BufferedImage thumb = PDFToImages.scaleToFit(pageImage, this.width, this.height);
                        Blob resultBlob = this.imageToBlob(thumb, "jpg", ".jpg", "image/jpeg", pageIndex + 1);
                        results.add((Object)resultBlob);
                    }
                    blobList = results;
                    if (document == null) break block15;
                }
                catch (Throwable throwable) {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                document.close();
            }
            return blobList;
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to extract the pages", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Blob getJpegPreviewImage(int pageNum) {
        ImageIO.scanForPlugins();
        try (CloseableFile source = this.pdfBlob.getCloseableFile();){
            Blob blob;
            block14: {
                PDDocument document = Loader.loadPDF((File)source.getFile());
                try {
                    int pageCount = document.getNumberOfPages();
                    PDFTools.validatePageNumber(pageNum, pageCount, "" + pageNum);
                    PDFRenderer renderer = new PDFRenderer(document);
                    int pageIndex = pageNum - 1;
                    BufferedImage pageImage = renderer.renderImageWithDPI(pageIndex, 300.0f, ImageType.RGB);
                    Blob resultBlob = this.imageToBlob(pageImage, "jpg", ".jpg", "image/jpeg", pageNum);
                    SimpleBlobHolder bh = new SimpleBlobHolder(resultBlob);
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("width", PREVIEW_PAGE_MAX_SIZE);
                    parameters.put("height", PREVIEW_PAGE_MAX_SIZE);
                    parameters.put("conversionFormat", "jpg");
                    BlobHolder holder = ((ConversionService)Framework.getService(ConversionService.class)).convert("pictureResize", (BlobHolder)bh, parameters);
                    Blob resizedBlob = holder.getBlob();
                    resizedBlob.setMimeType("image/jpeg");
                    resultBlob.setFilename(resultBlob.getFilename());
                    blob = resizedBlob;
                    if (document == null) break block14;
                }
                catch (Throwable throwable) {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                document.close();
            }
            return blob;
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to extract the page and make it a PNG.", (Throwable)e);
        }
    }

    protected Blob imageToBlob(BufferedImage img, String formatName, String fileExtension, String mimeType, int pageNum) throws IOException {
        String fileNameNoExt = PDFTools.getFileNameNoExtension(this.pdfBlob, "pdf-img", "-p" + pageNum);
        File resultFile = Framework.createTempFile((String)fileNameNoExt, (String)fileExtension);
        ImageIO.write((RenderedImage)img, formatName, resultFile);
        FileBlob result = new FileBlob(resultFile);
        result.setFilename(fileNameNoExt + fileExtension);
        result.setMimeType(mimeType);
        Framework.trackFile((File)resultFile, (Object)result);
        return result;
    }

    public static JSONArray toBase64JSONArray(BlobList blobs) {
        JSONArray array = new JSONArray();
        try {
            for (Blob blob : blobs) {
                byte[] bytes = blob.getByteArray();
                String base64 = Base64.getEncoder().encodeToString(bytes);
                array.put((Object)base64);
            }
            return array;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage scaleToFit(BufferedImage src, int maxWidth, int maxHeight) {
        int h;
        double scaleH;
        int w = src.getWidth();
        double scaleW = (double)maxWidth / (double)w;
        double scale = Math.min(scaleW, scaleH = (double)maxHeight / (double)(h = src.getHeight()));
        if (scale > 1.0) {
            scale = 1.0;
        }
        int newW = (int)Math.round((double)w * scale);
        int newH = (int)Math.round((double)h * scale);
        BufferedImage dst = new BufferedImage(newW, newH, 1);
        Graphics2D g2d = dst.createGraphics();
        try {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.drawImage(src, 0, 0, newW, newH, null);
        }
        finally {
            g2d.dispose();
        }
        return dst;
    }
}

