/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.pdf.toolkit;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.model.Property;

public class PDFDestinationHandler {
    protected DocumentModel doc;
    protected Blob pdf;
    protected Destination destination;
    protected JSONObject details;

    public PDFDestinationHandler(DocumentModel doc, Blob pdf, String destinationDetailsJsonStr) {
        JSONObject destinationDetails;
        this.doc = doc;
        this.pdf = pdf;
        String destination = "download";
        JSONObject details = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)destinationDetailsJsonStr) && (destinationDetails = new JSONObject(destinationDetailsJsonStr)).has("destination")) {
            destination = destinationDetails.optString("destination", "download");
            if (destinationDetails.has("details")) {
                details = destinationDetails.optJSONObject("details");
            }
        }
        this.destination = Destination.fromLabel(destination);
        this.details = details;
        if (this.doc == null && this.destination != Destination.DOWNLOAD) {
            throw new NuxeoException("A document is required when desitnation is not just a download.");
        }
    }

    public Blob run() {
        CoreSession session = null;
        if (this.doc != null) {
            session = this.doc.getCoreSession();
        }
        switch (this.destination.ordinal()) {
            case 0: {
                return this.pdf;
            }
            case 2: {
                String xpath = null;
                if (this.details != null && this.details.has("xpath")) {
                    xpath = this.details.getString("xpath");
                }
                if (StringUtils.isBlank(xpath)) {
                    xpath = "files:files";
                }
                DocumentHelper.addBlob((Property)this.doc.getProperty(xpath), (Blob)this.pdf);
                this.doc = session.saveDocument(this.doc);
                return Blobs.createJSONBlob((String)"{\"status\": \"done\"}");
            }
            case 1: {
                String title;
                DocumentRef target = this.doc.getParentRef();
                ArrayList<CoreSession.CopyOption> options = new ArrayList<CoreSession.CopyOption>();
                if (this.details.optBoolean("resetLifeCycle", false)) {
                    options.add(CoreSession.CopyOption.RESET_LIFE_CYCLE);
                }
                if (StringUtils.isBlank((CharSequence)(title = this.details.optString("derivativeTitle", null)))) {
                    title = this.pdf.getFilename();
                }
                DocumentModel copy = session.copy(this.doc.getRef(), target, title, (CoreSession.CopyOption[])options.toArray(CoreSession.CopyOption[]::new));
                copy.setPropertyValue("dc:title", (Serializable)((Object)title));
                copy.setPropertyValue("file:content", (Serializable)this.pdf);
                copy = session.saveDocument(copy);
                JSONObject result = new JSONObject();
                result.put("status", (Object)"done");
                result.put("derivativeId", (Object)copy.getId());
                return Blobs.createJSONBlob((String)result.toString());
            }
            case 3: {
                if (this.details.optBoolean("createVersion", false)) {
                    String versionType = this.details.optString("versionType", "Minor").toLowerCase();
                    VersioningOption vo = "major".equals(versionType) ? VersioningOption.MAJOR : VersioningOption.MINOR;
                    this.doc.putContextData("VersioningOption", (Serializable)vo);
                    this.doc = session.saveDocument(this.doc);
                    this.doc = session.getDocument(this.doc.getRef());
                }
                this.doc.setPropertyValue("file:content", (Serializable)this.pdf);
                this.doc = session.saveDocument(this.doc);
                return Blobs.createJSONBlob((String)"{\"status\": \"done\"}");
            }
        }
        throw new IllegalArgumentException("Invalid destination");
    }

    public static enum Destination {
        DOWNLOAD("download"),
        DERIVATIVE("derivative"),
        ATTACHMENTS("attachments"),
        NEW_FILE("newFile");

        private final String label;

        private Destination(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public static Destination fromLabel(String label) {
            for (Destination d : Destination.values()) {
                if (!d.label.equalsIgnoreCase(label)) continue;
                return d;
            }
            throw new IllegalArgumentException("Unknown Destination label: " + label);
        }
    }
}

