/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.pdf.toolkit;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import nuxeo.labs.pdf.toolkit.PDFTools;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.runtime.api.Framework;

public class PDFToImages {
    public static final int DEFAULT_THUMBNAIL_SIZE = 512;
    public static final int DEFAULT_DPI = 512;
    public static final int PREVIEW_PAGE_MAX_SIZE = 1024;
    public static final String TRANSIENT_STORE_NAME = "PDFToolkitCache";
    protected int width = 512;
    protected int height = 512;
    protected int dpi = 512;
    protected Blob pdfBlob;

    public PDFToImages(DocumentModel doc) {
        this(doc, null);
    }

    public PDFToImages(DocumentModel doc, String xpath) {
        if (StringUtils.isBlank((CharSequence)xpath)) {
            xpath = "file:content";
        }
        this.pdfBlob = (Blob)doc.getPropertyValue(xpath);
    }

    public PDFToImages(Blob b) {
        this.pdfBlob = b;
    }

    public void setWidth(int value) {
        this.width = value > 0 ? value : 512;
    }

    public void setheight(int value) {
        this.height = value > 0 ? value : 512;
    }

    public void setSize(int size) {
        this.setWidth(size);
        this.setheight(size);
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setheight(height);
    }

    public void setSize(String size) {
        if (StringUtils.isBlank((CharSequence)size)) {
            this.setSize(512);
            return;
        }
        int idx = size.indexOf(120);
        if (idx <= 0 || idx == size.length() - 1) {
            throw new IllegalArgumentException("Malformed dimension string: " + size);
        }
        String wStr = size.substring(0, idx).trim();
        String hStr = size.substring(idx + 1).trim();
        try {
            this.width = Integer.parseInt(wStr);
            this.height = Integer.parseInt(hStr);
            this.setSize(this.width, this.height);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Malformed dimension string: " + size, e);
        }
    }

    public void setDpi(int value) {
        this.dpi = value > 0 ? value : 512;
    }

    public BlobList createThumbnails(int size) {
        this.setSize(size);
        return this.createThumbnails();
    }

    public BlobList createThumbnails(int width, int height) {
        this.setSize(width, height);
        return this.createThumbnails();
    }

    public BlobList createThumbnails(String size) {
        this.setSize(size);
        if (StringUtils.isBlank((CharSequence)size)) {
            return this.createThumbnails(0);
        }
        int idx = size.indexOf(120);
        if (idx <= 0 || idx == size.length() - 1) {
            throw new IllegalArgumentException("Malformed dimension string: " + size);
        }
        String wStr = size.substring(0, idx).trim();
        String hStr = size.substring(idx + 1).trim();
        try {
            this.width = Integer.parseInt(wStr);
            this.height = Integer.parseInt(hStr);
            if (this.width <= 0) {
                this.width = 512;
            }
            if (this.height == 0) {
                this.height = 512;
            }
            return this.createThumbnails();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Malformed dimension string: " + size, e);
        }
    }

    protected static TransientStore getTransientStore() {
        TransientStoreService transientStoreService = (TransientStoreService)Framework.getService(TransientStoreService.class);
        return transientStoreService.getStore(TRANSIENT_STORE_NAME);
    }

    protected String getCacheKey(Integer pageNum) {
        String pageNumSuffix = "-" + (pageNum != null ? pageNum : 0);
        String key = this.pdfBlob.getDigest();
        if (StringUtils.isNotBlank((CharSequence)key)) {
            return key + pageNumSuffix;
        }
        if (this.pdfBlob instanceof ManagedBlob) {
            key = ((ManagedBlob)this.pdfBlob).getKey();
        }
        if (StringUtils.isNotBlank((CharSequence)key)) {
            return key + pageNumSuffix;
        }
        String fileName = this.pdfBlob.getFilename();
        long length = this.pdfBlob.getLength();
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            return fileName + "-" + length + pageNumSuffix;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public BlobList createThumbnails() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Blob getJpegPreviewImage(int pageNum) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Blob imageToBlob(BufferedImage img, String formatName, String fileExtension, String mimeType, int pageNum) throws IOException {
        String fileNameNoExt = PDFTools.getFileNameNoExtension(this.pdfBlob, "pdf-img", "-p" + pageNum);
        File resultFile = Framework.createTempFile((String)fileNameNoExt, (String)fileExtension);
        ImageIO.write((RenderedImage)img, formatName, resultFile);
        FileBlob result = new FileBlob(resultFile);
        result.setFilename(fileNameNoExt + fileExtension);
        result.setMimeType(mimeType);
        return result;
    }

    public static JSONArray toBase64JSONArray(BlobList blobs) {
        JSONArray array = new JSONArray();
        try {
            for (Blob blob : blobs) {
                byte[] bytes = blob.getByteArray();
                String base64 = Base64.getEncoder().encodeToString(bytes);
                array.put((Object)base64);
            }
            return array;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage scaleToFit(BufferedImage src, int maxWidth, int maxHeight) {
        int h;
        double scaleH;
        int w = src.getWidth();
        double scaleW = (double)maxWidth / (double)w;
        double scale = Math.min(scaleW, scaleH = (double)maxHeight / (double)(h = src.getHeight()));
        if (scale > 1.0) {
            scale = 1.0;
        }
        int newW = (int)Math.round((double)w * scale);
        int newH = (int)Math.round((double)h * scale);
        BufferedImage dst = new BufferedImage(newW, newH, 1);
        Graphics2D g2d = dst.createGraphics();
        try {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.drawImage(src, 0, 0, newW, newH, null);
        }
        finally {
            g2d.dispose();
        }
        return dst;
    }
}

