/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.pdf.toolkit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;

public class PDFTools {
    public static PDDocument cloneDocument(PDDocument original) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        original.save((OutputStream)baos);
        return Loader.loadPDF((byte[])baos.toByteArray());
    }

    public static String getFileNameNoExtension(Blob blob, String defaultName, String suffixBeforeExt) {
        String fileName = blob.getFilename();
        Object fileNameNoExt = StringUtils.isBlank((CharSequence)fileName) ? defaultName : FilenameUtils.getBaseName((String)fileName);
        if (StringUtils.isNotBlank((CharSequence)suffixBeforeExt)) {
            fileNameNoExt = (String)fileNameNoExt + suffixBeforeExt;
        }
        return fileNameNoExt;
    }

    public static Blob saveToFileBlob(Blob source, PDDocument newPdf, String defaultNameNoExt, String suffixBeforeExt) throws IOException {
        String fileNameNoExt = PDFTools.getFileNameNoExtension(source, defaultNameNoExt, suffixBeforeExt);
        File tempFile = File.createTempFile(fileNameNoExt, ".pdf");
        newPdf.save(tempFile);
        FileBlob finalBlob = new FileBlob(tempFile);
        finalBlob.setFilename(fileNameNoExt + ".pdf");
        finalBlob.setMimeType("application/pdf");
        return finalBlob;
    }

    public static Set<Integer> parsePageRange(String range, int pageCount) {
        String[] parts;
        TreeSet<Integer> pages = new TreeSet<Integer>();
        for (String part : parts = range.split(",")) {
            String token = part.trim();
            if (token.isEmpty()) {
                throw new IllegalArgumentException("Empty token in range: \"" + range + "\"");
            }
            int dashIdx = token.indexOf(45);
            try {
                int end;
                if (dashIdx < 0) {
                    int page = Integer.parseInt(token);
                    PDFTools.validatePageNumber(page, pageCount, token);
                    if (page < 1 || page > pageCount) continue;
                    pages.add(page);
                    continue;
                }
                String startStr = token.substring(0, dashIdx).trim();
                String endStr = token.substring(dashIdx + 1).trim();
                if (startStr.isEmpty() || endStr.isEmpty()) {
                    throw new IllegalArgumentException("Malformed range segment: \"" + token + "\"");
                }
                int start = Integer.parseInt(startStr);
                if (start > (end = Integer.parseInt(endStr))) {
                    throw new IllegalArgumentException("Start page > end page in segment: \"" + token + "\"");
                }
                PDFTools.validatePageNumber(start, pageCount, token);
                PDFTools.validatePageNumber(end, pageCount, token);
                int clampedStart = Math.max(1, start);
                int clampedEnd = Math.min(pageCount, end);
                for (int p = clampedStart; p <= clampedEnd; ++p) {
                    pages.add(p);
                }
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid number in range segment: \"" + token + "\"", ex);
            }
        }
        return pages;
    }

    public static void validatePageNumber(int page, int pageCount, String segment) {
        if (page < 1) {
            throw new IllegalArgumentException("Page numbers must be >= 1 in segment: \"" + segment + "\"");
        }
        if (page > pageCount) {
            throw new IllegalArgumentException("Page " + page + " exceeds document page count " + pageCount + " in segment: \"" + segment + "\"");
        }
    }
}

