/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.pdf.toolkit.operations;

import nuxeo.labs.pdf.toolkit.PDFDestinationHandler;
import nuxeo.labs.pdf.toolkit.PDFPageOrdering;
import org.json.JSONArray;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="PDFLabs.ReorderPages", category="Conversion", label="PDF Reorder Pages", description="Input is either a Blob or a document. If a document, xpath is the field to use, file:content by default. pageOrderJsonStr is a JSON array as string, required, with the number of current pages, reorganized in the array. For example, passing [3,1,4,2] => move page 3 to first, page 1 to second etc. The number of pages can be less or equal to the original number of pages. destinationJsonStr is a JSON object telling the operation what to do with the pdf. Not passed => download. See documentation for details.")
public class PDFPageOrderingOp {
    public static final String ID = "PDFLabs.ReorderPages";
    @Context
    protected CoreSession session;
    @Param(name="xpath", required=false)
    protected String xpath = "file:content";
    @Param(name="pageOrderJsonStr", required=true)
    protected String pageOrderJsonStr;
    @Param(name="destinationJsonStr", required=false)
    protected String destinationJsonStr;
    protected DocumentModel doc = null;

    @OperationMethod
    public Blob run(DocumentModel doc) {
        Blob b = (Blob)doc.getPropertyValue(this.xpath);
        this.doc = doc;
        return this.run(b);
    }

    @OperationMethod
    public Blob run(Blob blob) {
        PDFPageOrdering pageOrdering = new PDFPageOrdering(blob);
        JSONArray arr = new JSONArray(this.pageOrderJsonStr);
        int[] newPageOrder = new int[arr.length()];
        for (int i = 0; i < arr.length(); ++i) {
            newPageOrder[i] = arr.getInt(i);
        }
        Blob resultPdf = pageOrdering.reorganizePdf(newPageOrder);
        PDFDestinationHandler destHandler = new PDFDestinationHandler(this.doc, resultPdf, this.destinationJsonStr);
        Blob result = destHandler.run();
        return result;
    }
}

