/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.rating.adapter;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.labs.rating.model.Rated;

public class RatedAdapter
implements Rated {
    public static String RATED_FACET = "Rated";
    public static String PROPERTY_AVG = "rated:avg";
    public static String PROPERTY_COUNT = "rated:count";
    protected DocumentModel doc;

    public RatedAdapter(DocumentModel doc) {
        this.doc = doc;
        if (!doc.hasFacet(RATED_FACET)) {
            doc.addFacet(RATED_FACET);
        }
    }

    @Override
    public double getAverage() {
        Double average = (Double)this.getPropertyValue(PROPERTY_AVG);
        return average != null ? average : 0.0;
    }

    @Override
    public void setAverage(double average) {
        this.setPropertyValue(PROPERTY_AVG, Double.valueOf(average));
    }

    @Override
    public long getCount() {
        Long count = (Long)this.getPropertyValue(PROPERTY_COUNT);
        return count != null ? count : 0L;
    }

    @Override
    public void setCount(long count) {
        this.setPropertyValue(PROPERTY_COUNT, Long.valueOf(count));
    }

    @Override
    public void copyValue(Rated rated) {
        this.setAverage(rated.getAverage());
        this.setCount(rated.getCount());
    }

    protected void setPropertyValue(String propertyName, Serializable value) {
        DocumentModel targetDoc;
        CoreSession session = this.doc.getCoreSession();
        this.doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
        this.doc.setPropertyValue(propertyName, value);
        this.doc = session.saveDocument(this.doc);
        if (this.doc.isProxy() && (targetDoc = session.getSourceDocument(this.doc.getRef())).isVersion()) {
            DocumentModel liveDocument = session.getSourceDocument((DocumentRef)new IdRef(targetDoc.getSourceId()));
            RatedAdapter liveAdapter = (RatedAdapter)liveDocument.getAdapter(RatedAdapter.class);
            liveAdapter.setPropertyValue(propertyName, value);
        }
    }

    protected Serializable getPropertyValue(String propertyName) {
        CoreSession session = this.doc.getCoreSession();
        if (this.doc.isProxy()) {
            DocumentModel targetDoc = session.getSourceDocument(this.doc.getRef());
            if (targetDoc.isVersion()) {
                DocumentModel liveDocument = session.getSourceDocument((DocumentRef)new IdRef(targetDoc.getSourceId()));
                RatedAdapter liveAdapter = (RatedAdapter)liveDocument.getAdapter(RatedAdapter.class);
                return liveAdapter.getPropertyValue(propertyName);
            }
            return null;
        }
        return this.doc.getPropertyValue(propertyName);
    }
}

