/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.rating.operations;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.labs.rating.model.Rating;
import org.nuxeo.labs.rating.service.RatingService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="GetRating", category="Document", label="Rate", description="")
public class GetRating {
    final JsonNodeFactory factory = JsonNodeFactory.instance;
    public static final String ID = "GetRating";
    @Context
    protected CoreSession session;

    @OperationMethod
    public Blob run(DocumentModel doc) {
        String username = this.session.getPrincipal().getName();
        RatingService service = (RatingService)Framework.getService(RatingService.class);
        Rating rating = service.getRating(this.session, doc.getId(), username);
        ObjectNode object = this.factory.objectNode();
        if (rating != null) {
            object.put("rating", rating.getRating());
            object.put("comment", rating.getComment());
        } else {
            object.put("rating", 0);
            object.put("comment", "");
        }
        return Blobs.createBlob((String)object.toString(), (String)"application/json");
    }
}

