/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.rating.service;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.labs.rating.adapter.RatedAdapter;
import org.nuxeo.labs.rating.adapter.RatingAdapter;
import org.nuxeo.labs.rating.model.Rated;
import org.nuxeo.labs.rating.model.Rating;
import org.nuxeo.labs.rating.service.RatingService;
import org.nuxeo.labs.rating.utils.Average;
import org.nuxeo.labs.rating.utils.DocumentHelper;

public class RatingServiceImpl
implements RatingService {
    protected static final Log log = LogFactory.getLog(RatingServiceImpl.class);

    @Override
    public void rate(CoreSession session, Rating rating) {
        DocumentModel targetDoc = session.getDocument((DocumentRef)new IdRef(rating.getDocId()));
        DocumentModel ratingDoc = this.getRatingDoc(session, rating.getDocId(), rating.getUsername());
        if (ratingDoc == null) {
            DocumentModel container = this.getContainer(session);
            ratingDoc = session.createDocumentModel(container.getPathAsString(), "Rating", "Rating");
            ratingDoc = session.createDocument(ratingDoc);
        } else {
            this.removeValueFromAverage(rating.getRating(), targetDoc);
        }
        Rating adapter = (Rating)ratingDoc.getAdapter(RatingAdapter.class);
        adapter.copyValue(rating);
        this.addValueToAverage(rating.getRating(), targetDoc);
        session.saveDocument(targetDoc);
        session.saveDocument(ratingDoc);
        session.save();
    }

    @Override
    public Rating getRating(CoreSession session, String docId, String username) {
        DocumentModel ratingDoc = this.getRatingDoc(session, docId, username);
        if (ratingDoc != null) {
            return (Rating)ratingDoc.getAdapter(RatingAdapter.class);
        }
        return null;
    }

    protected DocumentModel getContainer(CoreSession session) {
        DocumentModelList list = session.query("Select * From RatingContainer");
        if (list.size() > 0) {
            return (DocumentModel)list.get(0);
        }
        DocumentModel container = session.createDocumentModel("/", "RatingContainer", "RatingContainer");
        container.setPropertyValue("dc:title", (Serializable)((Object)"RatingContainer"));
        container = session.createDocument(container);
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = new ACLImpl("local");
        acp.addACL((ACL)acl);
        ACE ace = new ACE("members", "Write", true);
        acl.add(ace);
        session.setACP(container.getRef(), (ACP)acp, true);
        return container;
    }

    protected DocumentModel getRatingDoc(CoreSession session, String docId, String username) {
        DocumentModel doc = session.getDocument((DocumentRef)new IdRef(docId));
        String headDocumentId = DocumentHelper.getHeadDocumentId(doc);
        String query = String.format("Select * From Rating Where (rating:docId = '%s' OR rating:headId = '%s') AND rating:username = '%s'", docId, headDocumentId, username);
        DocumentModelList ratings = session.query(query);
        if (ratings.size() > 0) {
            return (DocumentModel)ratings.get(0);
        }
        return null;
    }

    protected void addValueToAverage(long value, DocumentModel doc) {
        Rated ratedAdapter = (Rated)doc.getAdapter(RatedAdapter.class);
        double newAvg = Average.addValueToAverage(value, ratedAdapter.getAverage(), ratedAdapter.getCount());
        ratedAdapter.setAverage(newAvg);
        ratedAdapter.setCount(ratedAdapter.getCount() + 1L);
    }

    protected void removeValueFromAverage(long value, DocumentModel doc) {
        Rated ratedAdapter = (Rated)doc.getAdapter(RatedAdapter.class);
        double newAvg = Average.removeValueFromAverage(value, ratedAdapter.getAverage(), ratedAdapter.getCount());
        ratedAdapter.setAverage(newAvg);
        ratedAdapter.setCount(ratedAdapter.getCount() - 1L);
    }
}

