/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.rating.adapter;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.labs.rating.model.Rating;

public class RatingAdapter
implements Rating {
    public static String PROPERTY_USERNAME = "rating:username";
    public static String PROPERTY_RATING = "rating:rating";
    public static String PROPERTY_COMMENT = "rating:comment";
    public static String PROPERTY_DOC_ID = "rating:docId";
    public static String PROPERTY_VERSION_ID = "rating:versionId";
    public static String PROPERTY_HEAD_ID = "rating:headId";
    private DocumentModel doc;

    public RatingAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public void setRating(long rating) {
        this.doc.setPropertyValue(PROPERTY_RATING, (Serializable)Long.valueOf(rating));
    }

    @Override
    public long getRating() {
        return (Long)this.doc.getPropertyValue(PROPERTY_RATING);
    }

    @Override
    public String getUsername() {
        return (String)((Object)this.doc.getPropertyValue(PROPERTY_USERNAME));
    }

    @Override
    public void setUsername(String username) {
        this.doc.setPropertyValue(PROPERTY_USERNAME, (Serializable)((Object)username));
    }

    @Override
    public String getDocId() {
        return (String)((Object)this.doc.getPropertyValue(PROPERTY_DOC_ID));
    }

    @Override
    public void setDocId(String docId) {
        this.doc.setPropertyValue(PROPERTY_DOC_ID, (Serializable)((Object)docId));
        this.updateDocumentIds();
    }

    @Override
    public String getComment() {
        String comment = (String)((Object)this.doc.getPropertyValue(PROPERTY_COMMENT));
        return comment != null ? comment : "";
    }

    @Override
    public void setComment(String comment) {
        this.doc.setPropertyValue(PROPERTY_COMMENT, (Serializable)((Object)comment));
    }

    @Override
    public void copyValue(Rating rating) {
        this.setDocId(rating.getDocId());
        this.setUsername(rating.getUsername());
        this.setRating(rating.getRating());
        this.setComment(rating.getComment());
    }

    public String getVersionId() {
        return (String)((Object)this.doc.getPropertyValue(PROPERTY_VERSION_ID));
    }

    public String getHeadId() {
        return (String)((Object)this.doc.getPropertyValue(PROPERTY_HEAD_ID));
    }

    protected void updateDocumentIds() {
        CoreSession session = this.doc.getCoreSession();
        DocumentModel ratedDocument = session.getDocument((DocumentRef)new IdRef(this.getDocId()));
        if (ratedDocument.isVersion()) {
            this.doc.setPropertyValue(PROPERTY_VERSION_ID, (Serializable)((Object)ratedDocument.getId()));
            this.doc.setPropertyValue(PROPERTY_HEAD_ID, (Serializable)((Object)ratedDocument.getSourceId()));
        } else if (ratedDocument.isProxy()) {
            DocumentModel targetDoc = session.getSourceDocument(ratedDocument.getRef());
            if (targetDoc.isVersion()) {
                this.doc.setPropertyValue(PROPERTY_VERSION_ID, (Serializable)((Object)ratedDocument.getSourceId()));
                this.doc.setPropertyValue(PROPERTY_HEAD_ID, (Serializable)((Object)targetDoc.getSourceId()));
            } else {
                this.doc.setPropertyValue(PROPERTY_HEAD_ID, (Serializable)((Object)ratedDocument.getSourceId()));
            }
        } else {
            this.doc.setPropertyValue(PROPERTY_HEAD_ID, (Serializable)((Object)ratedDocument.getId()));
        }
    }
}

