/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.thumbnail.automation;

import nuxeo.labs.thumbnail.automation.ThumbnailAutomationDescriptor;
import nuxeo.labs.thumbnail.automation.ThumbnailAutomationService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailService;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailServiceImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ThumbnailAutomationServiceImpl
extends DefaultComponent
implements ThumbnailAutomationService {
    private static final Log log = LogFactory.getLog(ThumbnailAutomationServiceImpl.class);
    public static final String CONFIG_EXT_POINT = "configuration";
    protected ThumbnailAutomationDescriptor config = null;

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void applicationStarted(ComponentContext context) {
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIG_EXT_POINT.equals(extensionPoint)) {
            if (this.config == null) {
                this.config = (ThumbnailAutomationDescriptor)contribution;
            } else {
                log.warn((Object)"More than one contribution loaded => we handle only the first one");
            }
        } else {
            log.warn((Object)("Received configuration for extension point '" + extensionPoint + "', but we do not handle this extension point."));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    @Override
    public Blob getThumbnail(DocumentModel doc, CoreSession session) {
        Blob result;
        if (this.config == null) {
            log.error((Object)"No configuration: Returning default thumbnail");
            return this.getDefaultThumbnail(doc, session);
        }
        String chainId = this.config.getChainId();
        if (StringUtils.isBlank((CharSequence)chainId)) {
            log.error((Object)"No chainID passed to the service: Returning default thumbnail");
            return this.getDefaultThumbnail(doc, session);
        }
        AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext octx = new OperationContext();
        octx.setInput((Object)doc);
        octx.setCoreSession(session);
        OperationChain chain = new OperationChain("getThumbnailCallbackChain");
        chain.add(chainId);
        try {
            result = (Blob)as.run(octx, chain);
        }
        catch (OperationException e) {
            throw new NuxeoException((Throwable)e);
        }
        return result;
    }

    protected Blob getDefaultThumbnail(DocumentModel doc, CoreSession session) {
        ThumbnailServiceImpl service = (ThumbnailServiceImpl)Framework.getService(ThumbnailService.class);
        return service.getDefaultFactory().getThumbnail(doc, session);
    }
}

