/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.thumbnails.enricher;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class ThumbnailsEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "thumbnails";
    public static final String THUMBNAIL_URL_LABEL = "thumbnailUrl";
    public static final String THUMBNAIL_ID_LABEL = "id";
    public static final String THUMBNAILS_HEADER_LIMIT = "thumbnail-limit";
    public static final String THUMBNAILS_HEADER_TYPES = "thumbnail-types";
    public static final String THUMBNAILS_HEADER_FACETS = "thumbnail-facets";
    private static final String THUMBNAIL_URL_PATTERN = "%s/api/v1/repo/%s/id/%s/@rendition/thumbnail";

    public ThumbnailsEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel theFolderish) throws IOException {
        if (theFolderish.hasFacet("Folderish")) {
            CoreSession session = theFolderish.getCoreSession();
            String thumbnailLimitString = (String)this.ctx.getParameter(THUMBNAILS_HEADER_LIMIT);
            String thumbnailTypesString = (String)this.ctx.getParameter(THUMBNAILS_HEADER_TYPES);
            String thumbnailFacetsString = (String)this.ctx.getParameter(THUMBNAILS_HEADER_FACETS);
            String theQuery = "SELECT * FROM Document WHERE ecm:parentId = '" + theFolderish.getId() + "'";
            if (thumbnailTypesString != null) {
                theQuery = theQuery + " AND ecm:primaryType IN (" + this.csvToQuoted(thumbnailTypesString) + ")";
            }
            if (thumbnailFacetsString != null) {
                theQuery = theQuery + " AND ecm:mixinType IN (" + this.csvToQuoted(thumbnailFacetsString) + ")";
            }
            DocumentModelList theChildren = thumbnailLimitString != null ? session.query(theQuery, Integer.parseInt(thumbnailLimitString)) : session.query(theQuery);
            long limit = theChildren.totalSize();
            jg.writeFieldName(NAME);
            jg.writeStartArray();
            int i = 0;
            while ((long)i < limit) {
                DocumentModel currentChild = (DocumentModel)theChildren.get(i);
                jg.writeStartObject();
                jg.writeStringField(THUMBNAIL_ID_LABEL, currentChild.getId());
                jg.writeStringField(THUMBNAIL_URL_LABEL, String.format(THUMBNAIL_URL_PATTERN, this.ctx.getBaseUrl().replaceAll("/$", ""), currentChild.getRepositoryName(), currentChild.getId()));
                jg.writeEndObject();
                ++i;
            }
            jg.writeEndArray();
        }
    }

    private String csvToQuoted(String csv) {
        List<String> valuesArray = Arrays.asList(StringUtils.split((String)StringUtils.trim((String)csv), (String)","));
        String quotedCsv = valuesArray.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","));
        return quotedCsv;
    }
}

