/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.user.registration.automation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.user.invite.UserRegistrationConfiguration;

@Operation(id="Service.InviteUser", category="Services", label="Invite a user", description="Send invitation for user to create account.")
public class InviteUserOp {
    public static final String ID = "Service.InviteUser";
    @Context
    protected OperationContext ctx;
    @Context
    protected UserInvitationService invitationService;
    @Param(name="email", required=true)
    protected String email;
    @Param(name="first_name", required=true)
    protected String first_name;
    @Param(name="last_name", required=true)
    protected String last_name;
    @Param(name="validationMethod", required=false)
    protected UserInvitationService.ValidationMethod validationMethod = UserInvitationService.ValidationMethod.EMAIL;
    @Param(name="autoAccept", required=false)
    protected boolean autoAccept = true;
    @Param(name="info", required=false)
    protected Map<String, Serializable> info = new HashMap<String, Serializable>();
    @Param(name="comment", required=false)
    protected String comment;
    @Param(name="groups", required=false)
    protected String[] groups = new String[]{"members"};
    @Param(name="Output Variable", required=true)
    protected String outputVariable;

    @OperationMethod
    public void run() {
        DocumentModel invitation = this.invitationService.getUserRegistrationModel(null);
        UserRegistrationConfiguration config = this.invitationService.getConfiguration();
        invitation.setPropertyValue(config.getUserInfoUsernameField(), (Serializable)((Object)this.email));
        invitation.setPropertyValue(config.getUserInfoFirstnameField(), (Serializable)((Object)this.first_name));
        invitation.setPropertyValue(config.getUserInfoLastnameField(), (Serializable)((Object)this.last_name));
        invitation.setPropertyValue(config.getUserInfoEmailField(), (Serializable)((Object)this.email));
        invitation.setPropertyValue(config.getUserInfoGroupsField(), (Serializable)this.groups);
        invitation.setPropertyValue(config.getUserInfoCompanyField(), (Serializable)((Object)this.email));
        invitation.setPropertyValue("registration:comment", (Serializable)((Object)this.comment));
        if (this.info.get("registration:originatingUser") == null) {
            String originatingUser = this.ctx.getCoreSession().getPrincipal().getName();
            this.info.put("registration:originatingUser", (Serializable)((Object)originatingUser));
        }
        String inviteId = this.invitationService.submitRegistrationRequest(invitation, this.info, this.validationMethod, this.autoAccept);
        this.ctx.put(this.outputVariable, (Object)inviteId);
    }
}

