/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactory;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.runtime.api.Framework;

public class DocTypeIconThumbnailFactory
implements ThumbnailFactory {
    public static final String NO_PREVIEW_ICON_PATH = "img" + File.separator + "preview_not_available.png";
    public static final String NULL_DOC_TYPE = "(null)";
    protected static Map<String, Blob> docTypesAndBlobs = new HashMap<String, Blob>();
    public static final String NO_THUMBNAIL_FALLBACK_NAME = "noThumbnail.png";
    protected static Blob noThumbnailFallbackBlob = null;
    protected static File noThumbnailFallbackFile = null;

    public Blob getThumbnail(DocumentModel doc, CoreSession session) {
        try {
            Blob thumbnail;
            if (doc.hasFacet("Thumbnail") && (thumbnail = (Blob)doc.getPropertyValue("thumb:thumbnail")) != null) {
                return thumbnail;
            }
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return this.getDefaultThumbnail(doc);
    }

    public Blob computeThumbnail(DocumentModel doc, CoreSession session) {
        return this.getDefaultThumbnail(doc);
    }

    public Blob getDefaultThumbnail(DocumentModel doc) {
        String docType = doc == null ? NULL_DOC_TYPE : doc.getType();
        Blob thumbnail = docTypesAndBlobs.get(docType);
        if (thumbnail != null) {
            return thumbnail;
        }
        String iconPath = null;
        if (doc == null) {
            iconPath = NO_PREVIEW_ICON_PATH;
        } else {
            TypeInfo typeInfo = (TypeInfo)doc.getAdapter(TypeInfo.class);
            iconPath = typeInfo.getBigIcon();
            if (iconPath == null) {
                iconPath = typeInfo.getIcon();
            }
            if (iconPath == null) {
                iconPath = NO_PREVIEW_ICON_PATH;
            }
        }
        try {
            File iconFile;
            Object path = "nuxeo.war";
            if (!iconPath.startsWith(File.separator)) {
                path = (String)path + File.separator;
            }
            if ((iconFile = FileUtils.getResourceFileFromContext((String)(path = (String)path + iconPath))) != null && iconFile.exists()) {
                MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
                String mimeType = mimetypeRegistry.getMimetypeFromFile(iconFile);
                if (mimeType == null) {
                    mimeType = mimetypeRegistry.getMimetypeFromFilename(iconPath);
                }
                thumbnail = Blobs.createBlob((File)iconFile, (String)mimeType);
                docTypesAndBlobs.put(docType, thumbnail);
                return thumbnail;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.getThumbnailFallback();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Blob getThumbnailFallback() {
        if (noThumbnailFallbackBlob != null && (noThumbnailFallbackFile == null || noThumbnailFallbackFile.exists())) return noThumbnailFallbackBlob;
        String text = "(No thumbnail)";
        Font font = new Font("Arial", 0, 12);
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        int width = fm.stringWidth(text) + 40;
        int height = fm.getHeight() + 20;
        g2d.dispose();
        img = new BufferedImage(width, height, 2);
        g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(0, 0, width - 1, height - 1);
        g2d.drawString(text, 10, fm.getAscent() + 10);
        g2d.dispose();
        try {
            noThumbnailFallbackBlob = Blobs.createBlobWithExtension((String)".png");
            noThumbnailFallbackFile = noThumbnailFallbackBlob.getFile();
            boolean ok = ImageIO.write((RenderedImage)img, "png", noThumbnailFallbackFile);
            noThumbnailFallbackBlob.setMimeType("image/png");
            noThumbnailFallbackBlob.setFilename(NO_THUMBNAIL_FALLBACK_NAME);
            if (ok) return noThumbnailFallbackBlob;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return noThumbnailFallbackBlob;
    }
}

