/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.BinaryPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.property.Attachment;

public class AttachmentScribe
extends BinaryPropertyScribe<Attachment> {
    public AttachmentScribe() {
        super(Attachment.class, "ATTACH");
    }

    @Override
    protected ICalDataType _dataType(Attachment property, ICalVersion version) {
        if (property.getContentId() != null) {
            return version == ICalVersion.V1_0 ? ICalDataType.CONTENT_ID : ICalDataType.URI;
        }
        return super._dataType(property, version);
    }

    @Override
    protected Attachment newInstance(byte[] data) {
        return new Attachment(null, data);
    }

    @Override
    protected Attachment newInstance(String value, ICalDataType dataType) {
        if (dataType == ICalDataType.CONTENT_ID) {
            String contentId = AttachmentScribe.getCidUriValue(value);
            if (contentId == null) {
                contentId = value;
            }
            Attachment attach = new Attachment(null, (String)null);
            attach.setContentId(contentId);
            return attach;
        }
        String contentId = AttachmentScribe.getCidUriValue(value);
        if (contentId != null) {
            Attachment attach = new Attachment(null, (String)null);
            attach.setContentId(contentId);
            return attach;
        }
        return new Attachment(null, value);
    }

    @Override
    protected String _writeText(Attachment property, WriteContext context) {
        String contentId = property.getContentId();
        if (contentId != null) {
            return context.getVersion() == ICalVersion.V1_0 ? '<' + contentId + '>' : "cid:" + contentId;
        }
        return super._writeText(property, context);
    }

    @Override
    protected void _writeXml(Attachment property, XCalElement element, WriteContext context) {
        String contentId = property.getContentId();
        if (contentId != null) {
            element.append(ICalDataType.URI, "cid:" + contentId);
            return;
        }
        super._writeXml(property, element, context);
    }

    @Override
    protected JCalValue _writeJson(Attachment property, WriteContext context) {
        String contentId = property.getContentId();
        if (contentId != null) {
            return JCalValue.single("cid:" + contentId);
        }
        return super._writeJson(property, context);
    }

    private static String getCidUriValue(String uri) {
        int colon = uri.indexOf(58);
        if (colon == 3) {
            String scheme = uri.substring(0, colon);
            return "cid".equalsIgnoreCase(scheme) ? uri.substring(colon + 1) : null;
        }
        if (uri.length() > 0 && uri.charAt(0) == '<' && uri.charAt(uri.length() - 1) == '>') {
            return uri.substring(1, uri.length() - 1);
        }
        return null;
    }
}

