/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.operations.pictures;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Labs.PictureCrop", category="Conversion", label="Crop Picture", description="Crop the input blob using the platform default ImagingComponent. top, left width and height are required and integers (pixels)")
public class PictureCrop {
    public static final String ID = "Labs.PictureCrop";
    private static final Logger log = LogManager.getLogger(PictureCrop.class);
    @Context
    protected ImagingService imagingService;
    @Param(name="top", required=true)
    protected Integer top;
    @Param(name="left", required=true)
    protected Integer left;
    @Param(name="width", required=true)
    protected Integer width;
    @Param(name="height", required=true)
    protected Integer height;

    @OperationMethod
    public Blob run(Blob input) {
        Blob cropped = this.imagingService.crop(input, this.left.intValue(), this.top.intValue(), this.width.intValue(), this.height.intValue());
        String ext = FilenameUtils.getExtension((String)cropped.getFilename());
        if (ext.equalsIgnoreCase("null") || StringUtils.isBlank((CharSequence)ext)) {
            MimetypeRegistry mimeTypeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            String baseName = FilenameUtils.getBaseName((String)cropped.getFilename());
            try {
                String mimeType = mimeTypeService.getMimetypeFromBlob(cropped);
                cropped.setMimeType(mimeType);
                switch (mimeType) {
                    case "image/jpg": 
                    case "image/jpeg": {
                        cropped.setFilename(baseName + ".jpg");
                        break;
                    }
                    case "image/png": {
                        cropped.setFilename(baseName + ".png");
                        break;
                    }
                    default: {
                        ext = null;
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("PictureCrop: Error when getting the mimetype from the cropped blob", (Throwable)e);
            }
        }
        return cropped;
    }
}

