/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.operations.pictures;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;

@Operation(id="Labs.PictureRemoveFromViews", category="Document", label="Picture Remove View", description="Remove the view viewName (case insensitive) from the input document. Save the document if saveDoc is true. Returns the document. The operation does nothing if input document does not have the picture schema, or if the view is not found.")
public class PictureRemoveFromViews {
    public static final String ID = "Labs.PictureRemoveFromViews";
    @Context
    protected CoreSession session;
    @Param(name="viewName", required=true)
    protected String viewName;
    @Param(name="saveDoc", required=false)
    protected Boolean saveDoc = false;

    @OperationMethod
    public DocumentModel run(DocumentModel input) {
        if (input.hasSchema("picture")) {
            MultiviewPicture mvp = (MultiviewPicture)input.getAdapter(MultiviewPicture.class);
            if (mvp.getView(this.viewName) == null) {
                String viewNameLowerCase = this.viewName.toLowerCase();
                for (PictureView pv : mvp.getViews()) {
                    if (!pv.getTitle().toLowerCase().equals(viewNameLowerCase)) continue;
                    this.viewName = pv.getTitle();
                    break;
                }
            }
            if (mvp.getView(this.viewName) != null) {
                mvp.removeView(this.viewName);
                if (this.saveDoc.booleanValue()) {
                    input = this.session.saveDocument(input);
                }
            }
        }
        return input;
    }
}

