/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.context.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.audit.api.DocumentHistoryReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.comment.CommentProcessorHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.context.ContextExtensionFactory;
import org.nuxeo.template.api.context.DocumentWrapper;

public class AuditExtensionFactory
implements ContextExtensionFactory {
    private static final Logger log = LogManager.getLogger(AuditExtensionFactory.class);
    public static List<LogEntry> testAuditEntries;

    public Object getExtension(DocumentModel currentDocument, DocumentWrapper wrapper, Map<String, Object> ctx) {
        DocumentHistoryReader historyReader = (DocumentHistoryReader)Framework.getService(DocumentHistoryReader.class);
        List<LogEntry> auditEntries = null;
        if (historyReader != null) {
            auditEntries = historyReader.getDocumentHistory(currentDocument, 0L, 1000L);
        } else if (Framework.isTestModeSet() && testAuditEntries != null) {
            auditEntries = testAuditEntries;
        } else {
            auditEntries = new ArrayList<LogEntry>();
            log.warn("Can not add Audit info to rendering context");
        }
        if (auditEntries != null) {
            try {
                auditEntries = this.preprocessAuditEntries(auditEntries, currentDocument.getCoreSession(), "en");
            }
            catch (MissingResourceException e) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = e::getMessage;
                log.warn("Unable to preprocess Audit entries : {}", supplierArray);
            }
            ctx.put("auditEntries", wrapper.wrap(auditEntries));
        }
        return null;
    }

    protected List<LogEntry> preprocessAuditEntries(List<LogEntry> auditEntries, CoreSession session, String lang) throws MissingResourceException {
        CommentProcessorHelper helper = new CommentProcessorHelper(session);
        for (LogEntry entry : auditEntries) {
            String comment = helper.getLogComment(entry);
            if (comment == null) {
                comment = "";
            } else {
                String i18nComment = I18NUtils.getMessageString((String)"messages", (String)comment, null, (Locale)new Locale(lang));
                if (i18nComment != null) {
                    comment = i18nComment;
                }
            }
            String eventId = entry.getEventId();
            String i18nEventId = I18NUtils.getMessageString((String)"messages", (String)eventId, null, (Locale)new Locale(lang));
            if (i18nEventId != null) {
                entry.setEventId(i18nEventId);
            }
            entry.setComment(comment);
        }
        return auditEntries;
    }
}

