/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.serializer.executors;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.template.api.InputType;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.serializer.executors.TemplateSerializer;

public class XMLTemplateSerializer
implements TemplateSerializer {
    public static final String XML_NAMESPACE = "http://www.nuxeo.org/DocumentTemplate";
    public static final String XML_NAMESPACE_PREFIX = "nxdt";
    public static final Namespace ns = new Namespace("nxdt", "http://www.nuxeo.org/DocumentTemplate");
    public static final QName fieldsTag = DocumentFactory.getInstance().createQName("templateParams", ns);
    public static final QName fieldTag = DocumentFactory.getInstance().createQName("field", ns);
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final Logger log = LogManager.getLogger(XMLTemplateSerializer.class);

    @Override
    public List<TemplateInput> deserialize(String xml) {
        try {
            Document xmlDoc = DocumentHelper.parseText((String)xml);
            List nodes = xmlDoc.getRootElement().elements(fieldTag);
            return nodes.stream().map(this::extractTemplateInputFromXMLNode).collect(Collectors.toList());
        }
        catch (DocumentException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected TemplateInput extractTemplateInputFromXMLNode(Element node) {
        String paramName = this.getNameFromXMLNode(node);
        InputType paramType = this.getTypeFromXMLNode(node);
        String paramDesc = node.getText();
        Boolean isReadonly = this.getIsReadonlyFromXMLNode(node);
        Boolean isAutoloop = this.getIsAutoloopFromXMLNode(node);
        LinkedHashMap<String, TemplateInput> paramValue = node.attributeValue("value");
        switch (paramType) {
            case StringValue: 
            case BooleanValue: {
                break;
            }
            case DateValue: {
                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
                try {
                    paramValue = dateFormat.parse((String)((Object)paramValue));
                    break;
                }
                catch (ParseException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            case MapValue: 
            case ListValue: {
                LinkedHashMap<String, TemplateInput> listValue = new LinkedHashMap<String, TemplateInput>();
                for (Element childNode : node.elements()) {
                    TemplateInput childParam = this.extractTemplateInputFromXMLNode(childNode);
                    if (childNode == null) continue;
                    listValue.put(childParam.getName(), childParam);
                }
                paramValue = listValue;
                break;
            }
            default: {
                paramValue = node.attributeValue("source");
            }
        }
        return TemplateInput.factory((String)paramName, (InputType)paramType, (Object)paramValue, (String)paramDesc, (Boolean)isReadonly, (Boolean)isAutoloop);
    }

    protected Boolean getIsReadonlyFromXMLNode(Element elem) {
        Attribute readonly = elem.attribute("readonly");
        return readonly != null ? Boolean.valueOf(Boolean.parseBoolean(readonly.getValue())) : null;
    }

    protected Boolean getIsAutoloopFromXMLNode(Element elem) {
        Attribute autoloop = elem.attribute("autoloop");
        return autoloop != null ? Boolean.valueOf(Boolean.parseBoolean(autoloop.getValue())) : null;
    }

    protected String getNameFromXMLNode(Element elem) {
        Attribute name = elem.attribute("name");
        return name != null ? name.getValue() : null;
    }

    protected InputType getTypeFromXMLNode(Element elem) {
        InputType type = null;
        Attribute typeAtt = elem.attribute("type");
        if (typeAtt != null) {
            type = InputType.getByValue((String)typeAtt.getValue());
        }
        return type == null ? InputType.StringValue : type;
    }

    @Override
    public String serialize(List<TemplateInput> params) {
        Element root = DocumentFactory.getInstance().createElement(fieldsTag);
        for (TemplateInput param : params) {
            Element field = root.addElement(fieldTag);
            try {
                this.doSerialization(field, param);
            }
            catch (TemplateInputBadFormat e) {
                log.error("Can't Serialize the following param: {}", (Object)param);
                root.remove(field);
            }
        }
        return root.asXML();
    }

    protected void doSerialization(Element field, TemplateInput param) {
        field.addAttribute("name", param.getName());
        InputType type = param.getType();
        if (type == null) {
            if (param.getStringValue() == null) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((TemplateInput)param).getName();
                log.warn("Null param: {}", supplierArray);
                throw new TemplateInputBadFormat();
            }
            type = InputType.StringValue;
        }
        field.addAttribute("type", type.getValue());
        if (param.isReadOnly()) {
            field.addAttribute("readonly", "true");
        }
        if (param.isAutoLoop()) {
            field.addAttribute("autoloop", "true");
        }
        if (param.getDesciption() != null) {
            field.setText(param.getDesciption());
        }
        switch (type) {
            case StringValue: {
                field.addAttribute("value", param.getStringValue());
                break;
            }
            case DateValue: {
                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
                field.addAttribute("value", dateFormat.format(param.getDateValue()));
                break;
            }
            case BooleanValue: {
                field.addAttribute("value", param.getBooleanValue().toString());
                break;
            }
            case MapValue: 
            case ListValue: {
                Map map = param.getMapValue();
                for (String childParamName : map.keySet()) {
                    TemplateInput childParam = (TemplateInput)map.get(childParamName);
                    if (InputType.MapValue.equals((Object)type) && !childParamName.equals(childParam.getName())) {
                        log.warn("Child param in map and child param name doesn't match, get child param name as key: {}", (Object)childParam);
                    }
                    Element subfield = field.addElement(fieldTag);
                    this.doSerialization(subfield, childParam);
                }
                break;
            }
            case DocumentProperty: 
            case PictureProperty: 
            case Content: {
                field.addAttribute("source", param.getSource());
            }
        }
    }

    protected static class TemplateInputBadFormat
    extends NuxeoException {
        protected TemplateInputBadFormat() {
        }
    }
}

