/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.controller;

import java.util.ArrayList;
import java.util.List;
import net.sf.jxls.controller.SheetTransformationController;
import net.sf.jxls.formula.FormulaController;
import net.sf.jxls.parser.Cell;
import net.sf.jxls.tag.Block;
import net.sf.jxls.transformation.DuplicateTransformation;
import net.sf.jxls.transformation.DuplicateTransformationByColumns;
import net.sf.jxls.transformation.RemoveTransformation;
import net.sf.jxls.transformation.ShiftTransformation;
import net.sf.jxls.transformer.RowCollection;
import net.sf.jxls.transformer.Sheet;
import net.sf.jxls.util.TagBodyHelper;
import net.sf.jxls.util.Util;
import org.apache.poi.ss.usermodel.Row;

public class SheetTransformationControllerImpl
implements SheetTransformationController {
    List transformations = new ArrayList();
    Sheet sheet;
    FormulaController formulaController;

    public SheetTransformationControllerImpl(Sheet sheet) {
        this.sheet = sheet;
        this.formulaController = sheet.getWorkbook().getFormulaController();
    }

    @Override
    public int duplicateDown(Block block, int n) {
        if (n > 0) {
            if (block.getSheet() == null) {
                block.setSheet(this.sheet);
            }
            ShiftTransformation shiftTransformation = new ShiftTransformation(new Block(this.sheet, block.getEndRowNum() + 1, Integer.MAX_VALUE), n * block.getNumberOfRows(), 0);
            this.transformations.add(shiftTransformation);
            DuplicateTransformation duplicateTransformation = new DuplicateTransformation(block, n);
            this.transformations.add(duplicateTransformation);
            this.formulaController.updateWorkbookFormulas(shiftTransformation);
            this.formulaController.updateWorkbookFormulas(duplicateTransformation);
            return TagBodyHelper.duplicateDown(this.sheet.getPoiSheet(), block, n);
        }
        return 0;
    }

    @Override
    public int duplicateRight(Block block, int n) {
        if (n > 0) {
            ShiftTransformation shiftTransformation = new ShiftTransformation(new Block(this.sheet, block.getStartRowNum(), block.getEndCellNum() + 1, block.getEndRowNum(), Integer.MAX_VALUE), 0, block.getNumberOfColumns() * n);
            this.transformations.add(shiftTransformation);
            if (block.getSheet() == null) {
                block.setSheet(this.sheet);
            }
            DuplicateTransformationByColumns duplicateTransformation = new DuplicateTransformationByColumns(block, n);
            this.transformations.add(duplicateTransformation);
            this.formulaController.updateWorkbookFormulas(shiftTransformation);
            this.formulaController.updateWorkbookFormulas(duplicateTransformation);
            return TagBodyHelper.duplicateRight(this.sheet.getPoiSheet(), block, n);
        }
        return 0;
    }

    @Override
    public void removeBorders(Block block) {
        this.transformations.add(new RemoveTransformation(new Block(this.sheet, block.getStartRowNum(), block.getStartRowNum())));
        ShiftTransformation shiftTransformation1 = new ShiftTransformation(new Block(this.sheet, block.getStartRowNum() + 1, Integer.MAX_VALUE), -1, 0);
        this.transformations.add(shiftTransformation1);
        this.transformations.add(new RemoveTransformation(new Block(this.sheet, block.getEndRowNum() - 1, block.getEndRowNum() - 1)));
        ShiftTransformation shiftTransformation2 = new ShiftTransformation(new Block(this.sheet, block.getEndRowNum(), Integer.MAX_VALUE), -1, 0);
        this.transformations.add(shiftTransformation2);
        this.formulaController.updateWorkbookFormulas(shiftTransformation1);
        this.formulaController.updateWorkbookFormulas(shiftTransformation2);
        TagBodyHelper.removeBorders(this.sheet.getPoiSheet(), block);
    }

    @Override
    public void removeLeftRightBorders(Block block) {
        this.transformations.add(new RemoveTransformation(new Block(this.sheet, block.getStartRowNum(), block.getStartCellNum(), block.getEndRowNum(), block.getStartCellNum())));
        ShiftTransformation shiftTransformation1 = new ShiftTransformation(new Block(this.sheet, block.getStartRowNum(), block.getStartCellNum() + 1, block.getEndRowNum(), Integer.MAX_VALUE), 0, -1);
        this.transformations.add(shiftTransformation1);
        this.transformations.add(new RemoveTransformation(new Block(this.sheet, block.getStartRowNum(), block.getEndCellNum() - 1, block.getEndRowNum(), block.getEndCellNum() - 1)));
        ShiftTransformation shiftTransformation2 = new ShiftTransformation(new Block(this.sheet, block.getStartRowNum(), block.getEndCellNum(), block.getEndRowNum(), Integer.MAX_VALUE), 0, -1);
        this.transformations.add(shiftTransformation2);
        this.formulaController.updateWorkbookFormulas(shiftTransformation1);
        this.formulaController.updateWorkbookFormulas(shiftTransformation2);
        TagBodyHelper.removeLeftRightBorders(this.sheet.getPoiSheet(), block);
    }

    @Override
    public void removeRowCells(Row row, int startCellNum, int endCellNum) {
        this.transformations.add(new RemoveTransformation(new Block(this.sheet, row.getRowNum(), startCellNum, row.getRowNum(), endCellNum)));
        ShiftTransformation shiftTransformation = new ShiftTransformation(new Block(this.sheet, row.getRowNum(), endCellNum + 1, row.getRowNum(), Integer.MAX_VALUE), 0, endCellNum - startCellNum + 1);
        this.transformations.add(shiftTransformation);
        this.transformations.add(new RemoveTransformation(new Block(this.sheet, row.getRowNum(), row.getLastCellNum() - (endCellNum - startCellNum), row.getRowNum(), row.getLastCellNum())));
        this.formulaController.updateWorkbookFormulas(shiftTransformation);
        TagBodyHelper.removeRowCells(this.sheet.getPoiSheet(), row, startCellNum, endCellNum);
    }

    @Override
    public void removeBodyRows(Block block) {
        if (block.getSheet() == null) {
            block.setSheet(this.sheet);
        }
        RemoveTransformation removeTransformation = new RemoveTransformation(block);
        this.transformations.add(removeTransformation);
        ShiftTransformation shiftTransformation = new ShiftTransformation(new Block(this.sheet, block.getEndRowNum() + 1, Integer.MAX_VALUE), -block.getNumberOfRows(), 0);
        this.transformations.add(shiftTransformation);
        this.formulaController.updateWorkbookFormulas(removeTransformation);
        this.formulaController.updateWorkbookFormulas(shiftTransformation);
        TagBodyHelper.removeBodyRows(this.sheet.getPoiSheet(), block);
    }

    @Override
    public void duplicateRow(RowCollection rowCollection) {
        int startRowNum = rowCollection.getParentRow().getPoiRow().getRowNum();
        int endRowNum = startRowNum + rowCollection.getDependentRowNumber();
        Block shiftBlock = new Block(this.sheet, endRowNum + 1, Integer.MAX_VALUE);
        ShiftTransformation shiftTransformation = new ShiftTransformation(shiftBlock, rowCollection.getCollectionProperty().getCollection().size() - 1, 0);
        this.transformations.add(shiftTransformation);
        Block duplicateBlock = new Block(this.sheet, startRowNum, endRowNum);
        DuplicateTransformation duplicateTransformation = new DuplicateTransformation(duplicateBlock, rowCollection.getCollectionProperty().getCollection().size() - 1);
        this.transformations.add(duplicateTransformation);
        List cells = rowCollection.getRowCollectionCells();
        int c = cells.size();
        for (int i = 0; i < c; ++i) {
            Cell cell = (Cell)cells.get(i);
            if (cell == null || cell.getPoiCell() == null) continue;
            shiftBlock.addAffectedColumn(cell.getPoiCell().getColumnIndex());
            duplicateBlock.addAffectedColumn(cell.getPoiCell().getColumnIndex());
        }
        this.formulaController.updateWorkbookFormulas(shiftTransformation);
        this.formulaController.updateWorkbookFormulas(duplicateTransformation);
        Util.duplicateRow(rowCollection);
    }

    @Override
    public List getTransformations() {
        return this.transformations;
    }

    @Override
    public Sheet getSheet() {
        return this.sheet;
    }
}

