/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.report;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.Iterator;
import org.apache.commons.beanutils.ResultSetDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetCollection
extends AbstractCollection {
    protected static final Log log = LogFactory.getLog(ResultSetCollection.class);
    ResultSet resultSet;
    ResultSetDynaClass rsDynaClass;
    private boolean lowerCase = true;
    private int numberOfRows;

    public ResultSetCollection(ResultSet resultSet) throws SQLException, NullPointerException {
        this.resultSet = resultSet;
        this.rsDynaClass = new ResultSetDynaClass(resultSet);
        try {
            this.setNumberOfRows();
        }
        catch (SQLException e) {
            log.error((Object)"Can't get number of ResultSet records. Try to pass it to a corresponding constructor", (Throwable)e);
            throw e;
        }
    }

    public ResultSetCollection(ResultSet resultSet, boolean lowerCase) throws SQLException, NullPointerException {
        this.resultSet = resultSet;
        this.lowerCase = lowerCase;
        this.rsDynaClass = new ResultSetDynaClass(resultSet, lowerCase);
        try {
            this.setNumberOfRows();
        }
        catch (SQLException e) {
            log.error((Object)"Can't get number of ResultSet records. Try to pass it to a corresponding constructor");
            throw e;
        }
    }

    public ResultSetCollection(ResultSet resultSet, int numberOfRows) throws SQLException, NullPointerException {
        this.resultSet = resultSet;
        this.numberOfRows = numberOfRows;
        this.rsDynaClass = new ResultSetDynaClass(resultSet, this.lowerCase);
    }

    public ResultSetCollection(ResultSet resultSet, int numberOfRows, boolean lowerCase) throws SQLException, NullPointerException {
        this.lowerCase = lowerCase;
        this.resultSet = resultSet;
        this.numberOfRows = numberOfRows;
        this.rsDynaClass = new ResultSetDynaClass(resultSet, lowerCase);
    }

    protected void setNumberOfRows() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.last();
            this.numberOfRows = this.resultSet.getRow();
            this.resultSet.beforeFirst();
        }
    }

    @Override
    public int size() {
        return this.numberOfRows;
    }

    @Override
    public Iterator iterator() {
        return this.rsDynaClass.iterator();
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }
}

