/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.tag;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.parser.Expression;
import net.sf.jxls.tag.BaseTag;
import net.sf.jxls.tag.Block;
import net.sf.jxls.tag.LoopStatus;
import net.sf.jxls.tag.TagContext;
import net.sf.jxls.transformation.ResultTransformation;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.transformer.SheetTransformer;
import net.sf.jxls.util.GroupData;
import net.sf.jxls.util.ReportUtil;
import net.sf.jxls.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Row;

public class ForEachTag
extends BaseTag {
    protected static final Log log = LogFactory.getLog(ForEachTag.class);
    public static final String TAG_NAME = "forEach";
    Configuration configuration = new Configuration();
    static final String GROUP_DATA_KEY = "group";
    private String select;
    private String items;
    private String var;
    private String varStatus;
    private String itemsKey;
    private String collectionPropertyName;
    private String groupBy;
    private String groupOrder;
    private Collection itemsCollection;

    public ForEachTag() {
        this.name = TAG_NAME;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getGroupOrder() {
        return this.groupOrder;
    }

    public void setGroupOrder(String groupOrder) {
        this.groupOrder = groupOrder;
    }

    public String getItems() {
        return this.items;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getVarStatus() {
        return this.varStatus;
    }

    public void setVarStatus(String varStatus) {
        this.varStatus = varStatus;
    }

    @Override
    public void init(TagContext context) {
        super.init(context);
        this.configuration = context.getSheet().getConfiguration();
        this.parseItemsProperty();
        this.parseSelectProperty();
        if (context.getBeans().containsKey(this.itemsKey)) {
            Object itemsObject = context.getBeans().get(this.itemsKey);
            this.itemsCollection = this.collectionPropertyName != null ? (Collection)Util.getProperty(itemsObject, this.collectionPropertyName) : (Collection)itemsObject;
        }
    }

    private void parseSelectProperty() {
        if (this.select != null) {
            if (this.select.startsWith(this.configuration.getStartExpressionToken()) && this.select.endsWith(this.configuration.getEndExpressionToken())) {
                this.select = this.select.substring(2, this.select.length() - 1);
            } else {
                log.error((Object)("select attribute should start with " + this.configuration.getStartExpressionToken() + " and end with " + this.configuration.getEndExpressionToken()));
            }
        }
    }

    private void parseItemsProperty() {
        if (this.items != null) {
            if (this.items.startsWith(this.configuration.getStartExpressionToken()) && this.items.endsWith(this.configuration.getEndExpressionToken())) {
                this.items = this.items.substring(2, this.items.length() - 1);
                try {
                    Expression expr = new Expression(this.items, this.tagContext.getBeans(), this.configuration);
                    Object obj = expr.evaluate();
                    if (obj instanceof Collection) {
                        this.itemsCollection = (Collection)obj;
                    }
                    if (obj.getClass().isArray()) {
                        this.itemsCollection = Arrays.asList(this.toObjectArray(obj));
                    }
                    throw new RuntimeException("items property in forEach tag must be either a collection or an array. " + this.items + " is not ");
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't parse an expression " + this.items, e);
                }
            } else {
                log.error((Object)("items attribute should start from " + this.configuration.getStartExpressionToken() + " and end with " + this.configuration.getEndExpressionToken()));
            }
        } else {
            log.error((Object)"Collection key is null");
        }
    }

    private Object[] toObjectArray(Object array) {
        if (this.isPrimitiveArray(array)) {
            int arrayLength = Array.getLength(array);
            Object[] result = (Object[])Array.newInstance(Object.class, arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Array.set(result, i, Array.get(array, i));
            }
            return result;
        }
        return (Object[])array;
    }

    private boolean isPrimitiveArray(Object obj) {
        return obj instanceof boolean[] || obj instanceof byte[] || obj instanceof char[] || obj instanceof short[] || obj instanceof int[] || obj instanceof long[] || obj instanceof float[] || obj instanceof double[];
    }

    @Override
    public ResultTransformation process(SheetTransformer sheetTransformer) {
        Block body;
        if (log.isDebugEnabled()) {
            log.debug((Object)("forEach tag processing. Attributes: var = " + this.var + ", items=" + this.items));
            log.debug((Object)("Current tagContext: " + this.tagContext));
            log.debug((Object)("Items Collection: " + this.itemsCollection));
        }
        if ((body = this.tagContext.getTagBody()).getNumberOfRows() == 1) {
            return this.processOneRowTag(sheetTransformer);
        }
        int shiftNumber = 0;
        Map beans = this.tagContext.getBeans();
        Collection collectionToProcess = null;
        if (this.groupBy == null || this.groupBy.length() == 0) {
            collectionToProcess = this.selectCollectionDataToProcess(beans);
        }
        if (!(this.itemsCollection == null || this.itemsCollection.isEmpty() || collectionToProcess != null && collectionToProcess.isEmpty())) {
            this.tagContext.getSheetTransformationController().removeBorders(body);
            shiftNumber -= 2;
            ResultTransformation shift = new ResultTransformation(0);
            if (this.groupBy == null || this.groupBy.length() == 0) {
                shiftNumber += this.tagContext.getSheetTransformationController().duplicateDown(body, collectionToProcess.size() - 1);
                shift = this.processCollectionItems(collectionToProcess, beans, body, sheetTransformer);
            } else {
                try {
                    Collection groupedData = ReportUtil.groupCollectionData(this.itemsCollection, this.groupBy, this.groupOrder, this.select, this.configuration);
                    shiftNumber += this.tagContext.getSheetTransformationController().duplicateDown(body, groupedData.size() - 1);
                    Object savedGroupData = null;
                    if (beans.containsKey(GROUP_DATA_KEY)) {
                        savedGroupData = beans.get(GROUP_DATA_KEY);
                    }
                    shift = this.processGroupedData(groupedData, beans, body, sheetTransformer);
                    beans.remove(GROUP_DATA_KEY);
                    if (savedGroupData != null) {
                        beans.put(GROUP_DATA_KEY, savedGroupData);
                    }
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)e, (Throwable)new Exception("Can't group collection data by " + this.groupBy, e));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e, (Throwable)new Exception("Can't group collection data by " + this.groupBy, e));
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e, (Throwable)new Exception("Can't group collection data by " + this.groupBy, e));
                }
            }
            shift.add(new ResultTransformation(shiftNumber, shiftNumber));
            shift.setTagProcessResult(true);
            return shift;
        }
        log.warn((Object)("Collection " + this.items + " is empty"));
        this.tagContext.getSheetTransformationController().removeBodyRows(body);
        ResultTransformation shift = new ResultTransformation(0);
        shift.add(new ResultTransformation(-1, -body.getNumberOfRows()));
        shift.setLastProcessedRow(-1);
        shift.setTagProcessResult(true);
        return shift;
    }

    private ResultTransformation processOneRowTag(SheetTransformer sheetTransformer) {
        Block body = this.tagContext.getTagBody();
        int shiftNumber = 0;
        Map beans = this.tagContext.getBeans();
        Collection collectionToProcess = null;
        if (this.groupBy == null || this.groupBy.length() == 0) {
            collectionToProcess = this.selectCollectionDataToProcess(beans);
        }
        if (!(this.itemsCollection == null || this.itemsCollection.isEmpty() || collectionToProcess != null && collectionToProcess.isEmpty())) {
            body.setSheet(this.tagContext.getSheet());
            this.tagContext.getSheetTransformationController().removeLeftRightBorders(body);
            shiftNumber -= 2;
            ResultTransformation shift = new ResultTransformation();
            shift.setLastProcessedRow(0);
            shift.setStartCellShift(body.getEndCellNum() + 1);
            if (this.groupBy == null || this.groupBy.length() == 0) {
                shiftNumber += this.tagContext.getSheetTransformationController().duplicateRight(body, collectionToProcess.size() - 1);
                this.processCollectionItemsOneRow(collectionToProcess, beans, body, shift, sheetTransformer);
            } else {
                try {
                    Collection groupedData = ReportUtil.groupCollectionData(this.itemsCollection, this.groupBy, this.groupOrder, this.select, this.configuration);
                    shiftNumber += this.tagContext.getSheetTransformationController().duplicateRight(body, groupedData.size() - 1);
                    Object savedGroupData = null;
                    if (beans.containsKey(GROUP_DATA_KEY)) {
                        savedGroupData = beans.get(GROUP_DATA_KEY);
                    }
                    this.processGroupedDataOneRow(groupedData, beans, body, shift, sheetTransformer);
                    beans.remove(GROUP_DATA_KEY);
                    if (savedGroupData != null) {
                        beans.put(GROUP_DATA_KEY, savedGroupData);
                    }
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)e, (Throwable)new Exception("Can't group collection data by " + this.groupBy, e));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e, (Throwable)new Exception("Can't group collection data by " + this.groupBy, e));
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e, (Throwable)new Exception("Can't group collection data by " + this.groupBy, e));
                }
            }
            shift.addRightShift((short)shiftNumber);
            shift.setTagProcessResult(true);
            return shift;
        }
        log.warn((Object)("Collection " + this.items + " is empty"));
        Row currentRow = this.tagContext.getSheet().getPoiSheet().getRow(body.getStartRowNum());
        this.tagContext.getSheetTransformationController().removeRowCells(currentRow, body.getStartCellNum(), body.getEndCellNum());
        ResultTransformation shift = new ResultTransformation(0);
        shift.add(new ResultTransformation((short)(-body.getNumberOfColumns()), (short)(-body.getNumberOfColumns())));
        shift.setTagProcessResult(true);
        return shift;
    }

    private ResultTransformation processGroupedData(Collection groupedData, Map beans, Block body, SheetTransformer sheetTransformer) {
        ResultTransformation shift = new ResultTransformation(0);
        int k = 0;
        for (GroupData groupData : groupedData) {
            beans.put(GROUP_DATA_KEY, groupData);
            try {
                int startRowNum = body.getStartRowNum() + shift.getLastRowShift() + body.getNumberOfRows() * k++;
                int endRowNum = startRowNum + body.getNumberOfRows() - 1;
                ResultTransformation processResult = sheetTransformer.processRows(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), startRowNum, endRowNum, beans, null);
                shift.add(processResult);
            }
            catch (ParsePropertyException e) {
                log.error((Object)"Can't parse property ", (Throwable)e);
            }
        }
        return shift;
    }

    private void processGroupedDataOneRow(Collection groupedData, Map beans, Block body, ResultTransformation shift, SheetTransformer sheetTransformer) {
        int k = 0;
        for (GroupData groupData : groupedData) {
            beans.put(GROUP_DATA_KEY, groupData);
            try {
                short startColNum = (short)(body.getStartCellNum() + shift.getLastCellShift() + body.getNumberOfColumns() * k++);
                short endColNum = (short)(startColNum + body.getNumberOfColumns() - 1);
                ResultTransformation processResult = sheetTransformer.processRow(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), this.tagContext.getSheet().getPoiSheet().getRow(body.getStartRowNum()), startColNum, endColNum, beans, null);
                shift.add(processResult);
            }
            catch (ParsePropertyException e) {
                log.error((Object)"Can't parse property ", (Throwable)e);
            }
        }
    }

    private ResultTransformation processCollectionItems(Collection c2, Map beans, Block body, SheetTransformer sheetTransformer) {
        ResultTransformation shift = new ResultTransformation(0);
        int index = 0;
        int k = 0;
        LoopStatus status = new LoopStatus();
        if (this.varStatus != null) {
            beans.put(this.varStatus, status);
        }
        for (Object o : c2) {
            beans.put(this.var, o);
            status.setIndex(index);
            try {
                int startRowNum = body.getStartRowNum() + shift.getLastRowShift() + body.getNumberOfRows() * k++;
                int endRowNum = startRowNum + body.getNumberOfRows() - 1;
                ResultTransformation processResult = sheetTransformer.processRows(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), startRowNum, endRowNum, beans, null);
                shift.add(processResult);
            }
            catch (ParsePropertyException e) {
                log.error((Object)"Can't parse property ", (Throwable)e);
                throw new RuntimeException("Can't parse property", e);
            }
            ++index;
        }
        if (this.varStatus != null) {
            beans.remove(this.varStatus);
        }
        return shift;
    }

    private void processCollectionItemsOneRow(Collection c2, Map beans, Block body, ResultTransformation shift, SheetTransformer sheetTransformer) {
        int k = 0;
        int index = 0;
        LoopStatus status = new LoopStatus();
        if (this.varStatus != null) {
            beans.put(this.varStatus, status);
        }
        for (Object o : c2) {
            beans.put(this.var, o);
            status.setIndex(index);
            try {
                short startCellNum = (short)(body.getStartCellNum() + shift.getLastCellShift() + body.getNumberOfColumns() * k++);
                short endCellNum = (short)(startCellNum + body.getNumberOfColumns() - 1);
                ResultTransformation processResult = sheetTransformer.processRow(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), this.tagContext.getSheet().getPoiSheet().getRow(body.getStartRowNum()), startCellNum, endCellNum, beans, null);
                shift.add(processResult);
            }
            catch (Exception e) {
                log.error((Object)"Can't parse property ", (Throwable)e);
            }
            ++index;
        }
        if (this.varStatus != null) {
            beans.remove(this.varStatus);
        }
    }

    private Collection selectCollectionDataToProcess(Map beans) {
        ArrayList c2 = new ArrayList();
        for (Object o : this.itemsCollection) {
            beans.put(this.var, o);
            if (!ReportUtil.shouldSelectCollectionData(beans, this.select, this.configuration)) continue;
            c2.add(o);
        }
        return c2;
    }
}

