/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.util;

import java.lang.reflect.InvocationTargetException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jxls.parser.Expression;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.util.GroupData;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class ReportUtil {
    public static Collection groupCollectionData(Collection objects, String groupBy) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ArrayList<GroupData> result = new ArrayList<GroupData>();
        if (objects != null) {
            TreeSet<Object> groupByValues = new TreeSet<Object>();
            for (Object e : objects) {
                groupByValues.add(PropertyUtils.getProperty(e, (String)groupBy));
            }
            for (Object e : groupByValues) {
                BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate(groupBy, e);
                Collection groupItems = CollectionUtils.select((Collection)objects, (Predicate)predicate);
                GroupData groupData = new GroupData(CollectionUtils.get((Object)groupItems, (int)0), groupItems);
                result.add(groupData);
            }
        }
        return result;
    }

    public static Collection groupCollectionData(Collection objects, String groupBy, String groupOrder, String select, Configuration configuration) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ArrayList<GroupData> result = new ArrayList<GroupData>();
        if (objects != null) {
            AbstractSet groupByValues = groupOrder != null ? ("desc".equalsIgnoreCase(groupOrder) ? new TreeSet(Collections.reverseOrder()) : new TreeSet()) : new LinkedHashSet();
            HashMap beans = new HashMap();
            for (Object bean : objects) {
                beans.put("group.item", bean);
                if (!ReportUtil.shouldSelectCollectionData(beans, select, configuration)) continue;
                groupByValues.add(PropertyUtils.getProperty(bean, (String)groupBy));
            }
            for (Object groupValue : groupByValues) {
                BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate(groupBy, groupValue);
                Collection groupItems = CollectionUtils.select((Collection)objects, (Predicate)predicate);
                GroupData groupData = new GroupData(CollectionUtils.get((Object)groupItems, (int)0), groupItems);
                result.add(groupData);
            }
        }
        return result;
    }

    public static boolean shouldSelectCollectionData(Map beans, String select, Configuration configuration) {
        if (select == null) {
            return true;
        }
        try {
            Expression expr = new Expression(select, beans, configuration);
            Object obj = expr.evaluate();
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            return false;
        }
        catch (Exception e) {
            System.err.println("Exception evaluation select '" + select + "': " + e);
            return false;
        }
    }
}

