/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.tag;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.report.ReportManager;
import net.sf.jxls.tag.BaseTag;
import net.sf.jxls.tag.Block;
import net.sf.jxls.transformation.ResultTransformation;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.transformer.SheetTransformer;
import net.sf.jxls.util.ReportUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQLTag
extends BaseTag {
    protected static final Log log = LogFactory.getLog(SQLTag.class);
    Configuration configuration = new Configuration();
    public static final String REPORT_MANAGER_KEY = "reportManager";
    String query;
    String ref;
    String var;
    String select;

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    @Override
    public ResultTransformation process(SheetTransformer sheetTransformer) {
        ResultTransformation shift = new ResultTransformation(0);
        if (this.query != null) {
            if (this.tagContext.getBeans().containsKey(REPORT_MANAGER_KEY)) {
                ReportManager reportManager = (ReportManager)this.tagContext.getBeans().get(REPORT_MANAGER_KEY);
                try {
                    List results = reportManager.exec(this.query);
                    int shiftNumber = 0;
                    Block body = this.tagContext.getTagBody();
                    if (results != null && !results.isEmpty()) {
                        this.tagContext.getSheetTransformationController().removeBorders(body);
                        shiftNumber -= 2;
                        Map beans = this.tagContext.getBeans();
                        int k = 0;
                        ArrayList c2 = new ArrayList();
                        for (Object o : results) {
                            beans.put(this.var, o);
                            if (!ReportUtil.shouldSelectCollectionData(beans, this.select, this.configuration)) continue;
                            c2.add(o);
                        }
                        shiftNumber += this.tagContext.getSheetTransformationController().duplicateDown(body, c2.size() - 1);
                        for (Object o : c2) {
                            beans.put(this.var, o);
                            try {
                                int startRowNum = body.getStartRowNum() + shift.getLastRowShift() + body.getNumberOfRows() * k++;
                                int endRowNum = startRowNum + body.getNumberOfRows() - 1;
                                ResultTransformation processResult = sheetTransformer.processRows(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), startRowNum, endRowNum, beans, null);
                                shift.add(processResult);
                            }
                            catch (ParsePropertyException e) {
                                log.error((Object)"Can't parse property ", (Throwable)e);
                                throw new RuntimeException("Can't parse property", e);
                            }
                        }
                        shift.add(new ResultTransformation(shiftNumber, shiftNumber));
                        shift.setTagProcessResult(true);
                        return shift;
                    }
                    log.warn((Object)("Result set for query: " + this.query + " is empty"));
                    this.tagContext.getSheetTransformationController().removeBodyRows(body);
                    shift.add(new ResultTransformation(-1, -body.getNumberOfRows()));
                    shift.setLastProcessedRow(-1);
                    shift.setTagProcessResult(true);
                    return shift;
                }
                catch (SQLException e) {
                    log.error((Object)("Can't execute query " + this.query), (Throwable)e);
                }
            } else {
                log.error((Object)"Can't find ReportManager bean in the tag context under reportManager key.");
            }
        }
        return shift;
    }
}

