/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformation;

import java.util.ArrayList;
import java.util.List;
import net.sf.jxls.formula.CellRef;
import net.sf.jxls.tag.Block;
import net.sf.jxls.tag.Point;
import net.sf.jxls.transformation.BlockTransformation;

public class RemoveTransformation
extends BlockTransformation {
    public RemoveTransformation(Block block) {
        super(block);
    }

    @Override
    public Block getBlockAfterTransformation() {
        return null;
    }

    @Override
    public List transformCell(Point p) {
        ArrayList<Point> cells = null;
        if (!this.block.contains(p)) {
            cells = new ArrayList<Point>(1);
            cells.add(p);
        }
        return cells;
    }

    @Override
    public List transformCell(String sheetName, CellRef cellRef) {
        ArrayList<String> cells = null;
        String refSheetName = cellRef.getSheetName();
        if (this.block.getSheet().getSheetName().equalsIgnoreCase(refSheetName) || cellRef.getSheetName() == null && this.block.getSheet().getSheetName().equalsIgnoreCase(sheetName)) {
            if (!this.block.contains(cellRef.getRowNum(), cellRef.getColNum())) {
                cells = new ArrayList();
                cells.add(cellRef.toString());
            }
        } else {
            cells = new ArrayList<String>(1);
            cells.add(cellRef.toString());
        }
        return cells;
    }

    @Override
    public String toString() {
        return "RemoveTransformation: {" + super.toString() + "}";
    }
}

