/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.api.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.template.api.TemplateProcessor;

@XObject(value="templateProcessor")
public class TemplateProcessorDescriptor {
    private static final Logger log = LogManager.getLogger(TemplateProcessorDescriptor.class);
    protected TemplateProcessor processor;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@label")
    protected String label;
    @XNode(value="@class")
    protected Class<?> className;
    @XNode(value="@default")
    protected boolean defaultProcessor = true;
    @XNode(value="@enabled")
    protected boolean enabled = true;
    @XNodeList(value="supportedMimeType", type=ArrayList.class, componentType=String.class)
    protected List<String> supportedMimeTypes = new ArrayList<String>();
    @XNodeList(value="supportedExtension", type=ArrayList.class, componentType=String.class)
    protected List<String> supportedExtensions = new ArrayList<String>();

    public boolean init() {
        return this.getProcessor() != null;
    }

    public TemplateProcessor getProcessor() {
        if (this.processor == null) {
            try {
                this.processor = (TemplateProcessor)this.className.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.error("Unable to instantiate Processor", (Throwable)e);
            }
        }
        return this.processor;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public Class getClassName() {
        return this.className;
    }

    public List<String> getSupportedMimeTypes() {
        return this.supportedMimeTypes;
    }

    public List<String> getSupportedExtensions() {
        return this.supportedExtensions;
    }

    public boolean isDefaultProcessor() {
        return this.defaultProcessor;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TemplateProcessorDescriptor clone() {
        TemplateProcessorDescriptor clone = new TemplateProcessorDescriptor();
        clone.enabled = this.enabled;
        clone.supportedExtensions = this.supportedExtensions;
        clone.supportedMimeTypes = this.supportedMimeTypes;
        clone.className = this.className;
        clone.processor = this.processor;
        clone.defaultProcessor = this.defaultProcessor;
        clone.label = this.label;
        clone.name = this.name;
        return clone;
    }

    public void merge(TemplateProcessorDescriptor srcTpd) {
        this.defaultProcessor = srcTpd.defaultProcessor;
        if (srcTpd.className != null) {
            this.className = srcTpd.className;
        }
        if (srcTpd.label != null) {
            this.label = srcTpd.label;
        }
        if (srcTpd.supportedExtensions != null && srcTpd.supportedExtensions.size() > 0) {
            this.supportedExtensions = srcTpd.supportedExtensions;
        }
        if (srcTpd.supportedMimeTypes != null && srcTpd.supportedMimeTypes.size() > 0) {
            this.supportedMimeTypes = srcTpd.supportedMimeTypes;
        }
    }
}

