/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.operations;

import java.io.File;
import java.io.IOException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.utils.BlobUtils;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Labs.GetServerLog", category="Services", label="Get server.log", description="Zip server.log and returns it.")
public class GetServerLog {
    public static final String ID = "Labs.GetServerLog";

    @OperationMethod
    public Blob run() throws IOException {
        Object logPath = Framework.getProperty((String)"nuxeo.log.dir");
        if (!((String)logPath).endsWith("/")) {
            logPath = (String)logPath + "/";
        }
        logPath = (String)logPath + "server.log";
        File logFile = new File((String)logPath);
        FileBlob logBlob = new FileBlob(logFile);
        Blob zipped = BlobUtils.zip((Blob)logBlob, (String)"server.log.zip");
        return zipped;
    }
}

