/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.operations.pictures;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineConverter;

public class ConcatenateImagesConverter
extends CommandLineConverter {
    public static final String converterName = "concatenateImages";

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        List blobs = blobHolder.getBlobs();
        if (blobs.size() != 2) {
            throw new NuxeoException("The concatenateImages converter can handle only exactly 2 input blobs. We received " + blobs.size());
        }
        String destMimeType = (String)((Object)parameters.get("destMimeType"));
        if (destMimeType == null) {
            throw new NuxeoException("The concatenateImages converter expects a required parameter, destMimeType");
        }
        parameters.put("image1Path", (Serializable)((Object)((Blob)blobs.get(0)).getFile().getAbsolutePath()));
        parameters.put("image2Path", (Serializable)((Object)((Blob)blobs.get(1)).getFile().getAbsolutePath()));
        String horizontal = (String)((Object)parameters.get("horizontalAppend"));
        if (horizontal != null && "true".equals(horizontal.toLowerCase())) {
            parameters.put("HorV", (Serializable)((Object)"+"));
        } else {
            parameters.put("HorV", (Serializable)((Object)"-"));
        }
        BlobHolder result = super.convert(blobHolder, parameters);
        Blob resultBlob = result.getBlob();
        resultBlob.setMimeType(destMimeType);
        return new SimpleBlobHolder(resultBlob);
    }
}

