/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.operations.pictures;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.picture.api.ImagingService;

@Operation(id="Labs.PictureRotate", category="Conversion", label="Rotate Picture", description="Rotate the input blob using the platform default ImagingComponent. angle is a required integer")
public class PictureRotate {
    public static final String ID = "Labs.PictureRotate";
    @Context
    protected ImagingService imagingService;
    @Param(name="angle", required=true)
    protected Integer angle;

    @OperationMethod
    public Blob run(Blob input) {
        Blob rotated = this.imagingService.rotate(input, this.angle.intValue());
        String fileName = rotated.getFilename();
        String ext = FilenameUtils.getExtension((String)fileName);
        if (StringUtils.isBlank((CharSequence)ext) || "null".equals(ext)) {
            rotated.setFilename(input.getFilename());
        }
        return rotated;
    }
}

