/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.labs.utils.operations.videos;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.ecm.platform.video.VideoInfo;

@Operation(id="Labs.VideoAddToTranscodedVideos", category="Document", label="Add to Transcoded Videos", description="Add a new rendition (renditionName) to the vid:transcodedVideos field of the document referenced by the document parameter (id or path). It gets the info on the video (width, height, streams, ...) before adding it. If renditionName already exists, it is replaced. If the document does not have the video schema, the operation does nothing. Returns the modified document (saved if saveDoc is passed and true). ")
public class VideoAddToTranscodedVideos {
    public static final String ID = "Labs.VideoAddToTranscodedVideos";
    public static final String TRANSCODED_VIDEOS_FIELD = "vid:transcodedVideos";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Param(name="document", required=true)
    protected DocumentModel doc;
    @Param(name="renditionName", required=true)
    protected String renditionName;
    @Param(name="saveDoc", required=false)
    protected Boolean saveDoc = false;

    @OperationMethod
    public DocumentModel run(Blob input) {
        if (!this.doc.hasSchema("video")) {
            return this.doc;
        }
        VideoInfo info = VideoHelper.getVideoInfo((Blob)input);
        TranscodedVideo transcodedInput = TranscodedVideo.fromBlobAndInfo((String)this.renditionName, (Blob)input, (VideoInfo)info);
        List transcodedVideos = (ArrayList<Map>)this.doc.getPropertyValue(TRANSCODED_VIDEOS_FIELD);
        transcodedVideos = transcodedVideos == null ? new ArrayList<Map>() : transcodedVideos.stream().filter(map -> !transcodedInput.getName().equals(map.get("name"))).collect(Collectors.toList());
        transcodedVideos.add(transcodedInput.toMap());
        this.doc.setPropertyValue(TRANSCODED_VIDEOS_FIELD, (Serializable)((Object)transcodedVideos));
        if (this.saveDoc.booleanValue()) {
            this.doc = this.session.saveDocument(this.doc);
        }
        return this.doc;
    }
}

