/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.automation;

import java.util.List;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.serializer.executors.TemplateSerializer;
import org.nuxeo.template.serializer.service.TemplateSerializerService;

@Operation(id="TemplateProcessor.Render", category="Conversion", label="Render with template", description="Render the target document with the associated template if any. Returns the rendered Blob or the main Blob if no template is associated to the document.")
public class RenderWithTemplateOperation {
    public static final String ID = "TemplateProcessor.Render";
    @Context
    protected OperationContext ctx;
    @Param(name="templateName", required=false)
    protected String templateName = "default";
    @Param(name="store", required=false, values={"false"})
    protected Boolean store = false;
    @Param(name="save", required=false, values={"true"})
    protected Boolean save = true;
    @Param(name="attach", required=false)
    protected Boolean attach = false;
    @Param(name="templateData", required=false)
    protected String templateData = null;
    @Param(name="serializer", required=false)
    protected String serializerName;

    @OperationMethod
    public Blob run(DocumentModel targetDocument) {
        TemplateBasedDocument renderable = (TemplateBasedDocument)targetDocument.getAdapter(TemplateBasedDocument.class);
        if (this.attach.booleanValue() && (renderable == null || !renderable.getTemplateNames().contains(this.templateName))) {
            TemplateProcessorService tps = (TemplateProcessorService)Framework.getService(TemplateProcessorService.class);
            DocumentModel template = tps.getTemplateDoc(this.ctx.getCoreSession(), this.templateName);
            TemplateBasedDocument templateBasedDocument = renderable = template == null ? null : (TemplateBasedDocument)tps.makeTemplateBasedDocument(targetDocument, template, true).getAdapter(TemplateBasedDocument.class);
        }
        if (renderable != null) {
            TemplateSerializer templateSerializer;
            List<TemplateInput> params;
            if (this.templateData != null && (params = (templateSerializer = ((TemplateSerializerService)Framework.getService(TemplateSerializerService.class)).getSerializer(this.serializerName)).deserialize(this.templateData)) != null) {
                renderable.saveParams(this.templateName, params, true);
            }
            if (this.store.booleanValue()) {
                return renderable.renderAndStoreAsAttachment(this.templateName, this.save.booleanValue());
            }
            return renderable.renderWithTemplate(this.templateName);
        }
        BlobHolder bh = (BlobHolder)targetDocument.getAdapter(BlobHolder.class);
        if (bh != null) {
            return bh.getBlob();
        }
        return null;
    }
}

