/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.listeners;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.ShallowDocumentModel;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.adapters.TemplateAdapterFactory;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;

public class TemplateTypeBindingListener
implements PostCommitFilteringEventListener {
    private static final Logger log = LogManager.getLogger(TemplateTypeBindingListener.class);

    public boolean acceptEvent(Event event) {
        EventContext context = event.getContext();
        if (!(context instanceof DocumentEventContext)) {
            return false;
        }
        DocumentModel doc = ((DocumentEventContext)context).getSourceDocument();
        if (doc == null || doc.isVersion()) {
            return false;
        }
        return TemplateAdapterFactory.isAdaptable(doc, TemplateSourceDocument.class);
    }

    public void handleEvent(EventBundle eventBundle) {
        if (eventBundle.containsEventName("documentCreated") || eventBundle.containsEventName("documentModified")) {
            TemplateProcessorService tps = (TemplateProcessorService)Framework.getService(TemplateProcessorService.class);
            for (Event event : eventBundle) {
                DocumentEventContext docCtx;
                DocumentModel targetDoc;
                EventContext ctx;
                if (!"documentCreated".equals(event.getName()) && !"documentModified".equals(event.getName()) || !((ctx = event.getContext()) instanceof DocumentEventContext) || (targetDoc = (docCtx = (DocumentEventContext)ctx).getSourceDocument()).isVersion()) continue;
                if (targetDoc instanceof ShallowDocumentModel) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> ((DocumentModel)targetDoc).getType();
                    supplierArray[1] = () -> ((DocumentModel)targetDoc).getPathAsString();
                    log.warn("Skip unconnected document with type: {} and path: {}", supplierArray);
                    continue;
                }
                TemplateSourceDocument tmpl = (TemplateSourceDocument)targetDoc.getAdapter(TemplateSourceDocument.class);
                if (tmpl == null) continue;
                tps.registerTypeMapping(targetDoc);
                targetDoc.getCoreSession().save();
            }
        }
    }
}

