/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.jaxrs;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;

@WebObject(type="templateResource")
public class TemplateResource
extends DefaultObject {
    protected String uuid;

    public TemplateResource() {
        this.uuid = null;
    }

    protected void initialize(Object ... args) {
        if (args != null && args.length > 0) {
            this.uuid = (String)args[0];
        }
    }

    public TemplateResource(String value) {
        this.uuid = value;
    }

    protected TemplateSourceDocument resolve() {
        if (this.uuid != null) {
            IdRef idRef = new IdRef(this.uuid);
            DocumentModel doc = this.getContext().getCoreSession().getDocument((DocumentRef)idRef);
            return (TemplateSourceDocument)doc.getAdapter(TemplateSourceDocument.class);
        }
        return null;
    }

    @GET
    public Object get() {
        TemplateSourceDocument source = this.resolve();
        if (source == null) {
            return this.getList();
        }
        return source.getId() + " - " + source.getLabel();
    }

    protected String getList() {
        TemplateProcessorService tps = (TemplateProcessorService)Framework.getService(TemplateProcessorService.class);
        List sources = tps.getAvailableTemplates(this.getContext().getCoreSession(), null);
        StringBuilder sb = new StringBuilder();
        for (TemplateSourceDocument source : sources) {
            sb.append(source.getId()).append(" - ").append(source.getName()).append("-").append(source.getLabel()).append("\n");
        }
        return sb.toString();
    }

    @GET
    @Path(value="resource/{resourceName}")
    @Produces(value={"*/*"})
    public Blob getResource(@PathParam(value="resourceName") String resourceName) {
        TemplateSourceDocument tmpl = this.resolve();
        return TemplateResource.getResource(tmpl, resourceName);
    }

    static Blob getResource(TemplateSourceDocument tmpl, String resourceName) {
        BlobHolder bh = (BlobHolder)tmpl.getAdaptedDoc().getAdapter(BlobHolder.class);
        if (bh != null) {
            for (Blob blob : bh.getBlobs()) {
                if (!resourceName.equalsIgnoreCase(blob.getFilename())) continue;
                return blob;
            }
        }
        return null;
    }
}

